<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('location_create')): ?>
                <div style="margin-bottom: 10px;" class="row">
                    <div class="col-lg-12">
                        <a class="btn btn-success" href="<?php echo e(route('frontend.locations.create')); ?>">
                            <?php echo e(trans('global.add')); ?> <?php echo e(trans('cruds.location.title_singular')); ?>

                        </a>
                    </div>
                </div>
            <?php endif; ?>
            <div class="card">
                <div class="card-header">
                    <?php echo e(trans('cruds.location.title_singular')); ?> <?php echo e(trans('global.list')); ?>

                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class=" table table-bordered table-striped table-hover datatable datatable-Location">
                            <thead>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.id')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.title')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.address_line_1')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.address_line_2')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.landmark')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.city')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.state')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.country')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.zip')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.is_active')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.location.fields.is_primary')); ?>

                                    </th>
                                    <th>
                                        &nbsp;
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-entry-id="<?php echo e($location->id); ?>">
                                        <td>
                                            <?php echo e($location->id ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->title ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->address_line_1 ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->address_line_2 ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->landmark ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->city ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->state ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->country ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($location->zip ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e(App\Models\Location::IS_ACTIVE_SELECT[$location->is_active] ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e(App\Models\Location::IS_PRIMARY_SELECT[$location->is_primary] ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('location_show')): ?>
                                                <a class="btn btn-xs btn-primary" href="<?php echo e(route('frontend.locations.show', $location->id)); ?>">
                                                    <?php echo e(trans('global.view')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('location_edit')): ?>
                                                <a class="btn btn-xs btn-info" href="<?php echo e(route('frontend.locations.edit', $location->id)); ?>">
                                                    <?php echo e(trans('global.edit')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('location_delete')): ?>
                                                <form action="<?php echo e(route('frontend.locations.destroy', $location->id)); ?>" method="POST" onsubmit="return confirm('<?php echo e(trans('global.areYouSure')); ?>');" style="display: inline-block;">
                                                    <input type="hidden" name="_method" value="DELETE">
                                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                    <input type="submit" class="btn btn-xs btn-danger" value="<?php echo e(trans('global.delete')); ?>">
                                                </form>
                                            <?php endif; ?>

                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('location_delete')): ?>
  let deleteButtonTrans = '<?php echo e(trans('global.datatables.delete')); ?>'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "<?php echo e(route('frontend.locations.massDestroy')); ?>",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('<?php echo e(trans('global.datatables.zero_selected')); ?>')

        return
      }

      if (confirm('<?php echo e(trans('global.areYouSure')); ?>')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
<?php endif; ?>

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-Location:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/frontend/locations/index.blade.php ENDPATH**/ ?>