
<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('cruds.certificates.title_singular')); ?>

    </div>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.certificates.store")); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label class="required" for="teacher_id"><?php echo e(trans('cruds.certificates.fields.student')); ?></label>
                <select class="form-control select2 <?php echo e($<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Student Certificate Form</title>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
    }

    .container {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        border: 2px solid #ccc;
    }

    form {
        width: 80%;
        max-width: 600px;
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 10px;
        background-color: #f9f9f9;
    }

    label, input, select {
        display: block;
        margin-bottom: 10px;
    }

    input[type="submit"] {
        background-color: #4CAF50;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }

    input[type="submit"]:hover {
        background-color: #45a049;
    }

    .new-student-button {
        margin-bottom: 10px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 5px;
        padding: 10px 20px;
        cursor: pointer;
    }

    .email {
        width: 100%;
        padding: 10px;
        font-size: 16px;
        border: 1px solid #ccc;
        border-radius: 5px;
        height: 150px; /* Increased height */
        resize: vertical; /* Allow vertical resizing */
    }

    .student-dropdown {
        width: calc(100% - 120px); /* Adjusted width */
    }

    .student-select-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 10px;
    }
</style>
</head>
<body>

<div class="container">
    <form action="#" method="post">
        <div class="student-select-container">
            <label for="student" style="margin-right: 10px;">Select Student:</label>
            <select id="student" name="student" class="student-dropdown">
                <option value="student1">Student 1</option>
                <option value="student2">Student 2</option>
                <option value="student3">Student 3</option>
            </select>
            <button class="new-student-button">+</button> <!-- Changed to + symbol -->
        </div>

        <label for="refNo">Enter Reference No:</label>
        <input type="text" id="refNo" name="refNo" style="width: 100%; margin-bottom: 10px;">

        <div style="display:flex; justify-content: space-between;">
            <label for="certificate" style="margin-right: 10px;">Select Certificate:</label>
            <select id="certificate" name="certificate" style="flex-grow: 1;">
                <option value="certificate1">Certificate 1</option>
                <option value="certificate2">Certificate 2</option>
                <option value="certificate3">Certificate 3</option>
            </select>
            <label for="template" style="margin-right: 10px;">Select Template:</label>
            <select id="template" name="template">
                <option value="template1">Template 1</option>
                <option value="template2">Template 2</option>
                <option value="template3">Template 3</option>
            </select>
        </div>

        <label for="email">Email Template:</label>
        <textarea id="email" name="email" class="email" style="margin-bottom: 10px;">Write email here...</textarea>

        <input type="submit" value="Send">
    </form>
</div>

</body>
</html>errors->has('teacher') ? 'is-invalid' : ''); ?>" name="student_id" id="student_id" required>
                  <option value="">Select Student</option>
                    <?php $__currentLoopData = $studentAll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($entry->id); ?>"><?php echo e($entry->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('teacher')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('teacher')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.certificates.fields.teacher_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="title"><?php echo e(trans('cruds.certificates.fields.title')); ?></label>
                <input class="form-control <?php echo e($errors->has('title') ? 'is-invalid' : ''); ?>" type="text" name="title" id="title" value="<?php echo e(old('title', '')); ?>" required>
                <?php if($errors->has('title')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('title')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.certificates.fields.title_helper')); ?></span>
            </div>
            
            <div class="form-group">
                <label for="thumbnail"><?php echo e(trans('cruds.certificates.fields.thumbnail')); ?></label>
                <div class="needsclick dropzone <?php echo e($errors->has('thumbnail') ? 'is-invalid' : ''); ?>" id="thumbnail-dropzone">
                </div>
                <?php if($errors->has('thumbnail')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('thumbnail')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.certificates.fields.thumbnail_helper')); ?></span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    <?php echo e(trans('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    var uploadedThumbnailMap = {}
Dropzone.options.thumbnailDropzone = {
    url: '<?php echo e(route('admin.courses.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').append('<input type="hidden" name="thumbnail[]" value="' + response.name + '">')
      uploadedThumbnailMap[file.name] = response.name
    },
    removedfile: function (file) {
      console.log(file)
      file.previewElement.remove()
      var name = ''
      if (typeof file.file_name !== 'undefined') {
        name = file.file_name
      } else {
        name = uploadedThumbnailMap[file.name]
      }
      $('form').find('input[name="thumbnail[]"][value="' + name + '"]').remove()
    },
    init: function () {
<?php if(isset($course) && $course->thumbnail): ?>
      var files = <?php echo json_encode($course->thumbnail); ?>

          for (var i in files) {
          var file = files[i]
          this.options.addedfile.call(this, file)
          this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
          file.previewElement.classList.add('dz-complete')
          $('form').append('<input type="hidden" name="thumbnail[]" value="' + file.file_name + '">')
        }
<?php endif; ?>
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\lgbuniversity\resources\views/admin/certificates/create_ab.blade.php ENDPATH**/ ?>