<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.edit')); ?> <?php echo e(trans('cruds.user.title_singular')); ?>

    </div>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.users.update", [$user->id])); ?>" enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label class="required" for="name"><?php echo e(trans('cruds.user.fields.name')); ?></label>
                <input class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" type="text" name="name" id="name" value="<?php echo e(old('name', $user->name)); ?>" required>
                <?php if($errors->has('name')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('name')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.name_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="last_name"><?php echo e(trans('cruds.user.fields.last_name')); ?></label>
                <input class="form-control <?php echo e($errors->has('last_name') ? 'is-invalid' : ''); ?>" type="text" name="last_name" id="last_name" value="<?php echo e(old('last_name', $user->last_name)); ?>" required>
                <?php if($errors->has('last_name')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('last_name')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.last_name_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="email"><?php echo e(trans('cruds.user.fields.email')); ?></label>
                <input class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" type="email" name="email" id="email" value="<?php echo e(old('email', $user->email)); ?>" required>
                <?php if($errors->has('email')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('email')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.email_helper')); ?></span>
            </div>
            <div class="form-group">
                <label><?php echo e(trans('cruds.user.fields.gender')); ?></label>
                <?php $__currentLoopData = App\Models\User::GENDER_RADIO; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-check <?php echo e($errors->has('gender') ? 'is-invalid' : ''); ?>">
                        <input class="form-check-input" type="radio" id="gender_<?php echo e($key); ?>" name="gender" value="<?php echo e($key); ?>" <?php echo e(old('gender', $user->gender) === (string) $key ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="gender_<?php echo e($key); ?>"><?php echo e($label); ?></label>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($errors->has('gender')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('gender')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.gender_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="dob"><?php echo e(trans('cruds.user.fields.dob')); ?></label>
                <input class="form-control date <?php echo e($errors->has('dob') ? 'is-invalid' : ''); ?>" type="text" name="dob" id="dob" value="<?php echo e(old('dob', $user->dob)); ?>">
                <?php if($errors->has('dob')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('dob')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.dob_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="mobile_no"><?php echo e(trans('cruds.user.fields.mobile_no')); ?></label>
                <input class="form-control <?php echo e($errors->has('mobile_no') ? 'is-invalid' : ''); ?>" type="text" name="mobile_no" id="mobile_no" value="<?php echo e(old('mobile_no', $user->mobile_no)); ?>">
                <?php if($errors->has('mobile_no')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('mobile_no')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.mobile_no_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="address_line_1"><?php echo e(trans('cruds.user.fields.address_line_1')); ?></label>
                <input class="form-control <?php echo e($errors->has('address_line_1') ? 'is-invalid' : ''); ?>" type="text" name="address_line_1" id="address_line_1" value="<?php echo e(old('address_line_1', $user->address_line_1)); ?>">
                <?php if($errors->has('address_line_1')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('address_line_1')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.address_line_1_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="address_line_2"><?php echo e(trans('cruds.user.fields.address_line_2')); ?></label>
                <input class="form-control <?php echo e($errors->has('address_line_2') ? 'is-invalid' : ''); ?>" type="text" name="address_line_2" id="address_line_2" value="<?php echo e(old('address_line_2', $user->address_line_2)); ?>">
                <?php if($errors->has('address_line_2')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('address_line_2')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.address_line_2_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="city"><?php echo e(trans('cruds.user.fields.city')); ?></label>
                <input class="form-control <?php echo e($errors->has('city') ? 'is-invalid' : ''); ?>" type="text" name="city" id="city" value="<?php echo e(old('city', $user->city)); ?>">
                <?php if($errors->has('city')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('city')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.city_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="state"><?php echo e(trans('cruds.user.fields.state')); ?></label>
                <input class="form-control <?php echo e($errors->has('state') ? 'is-invalid' : ''); ?>" type="text" name="state" id="state" value="<?php echo e(old('state', $user->state)); ?>">
                <?php if($errors->has('state')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('state')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.state_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="coutry"><?php echo e(trans('cruds.user.fields.coutry')); ?></label>
                <input class="form-control <?php echo e($errors->has('coutry') ? 'is-invalid' : ''); ?>" type="text" name="coutry" id="coutry" value="<?php echo e(old('coutry', $user->coutry)); ?>">
                <?php if($errors->has('coutry')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('coutry')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.coutry_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="pincode"><?php echo e(trans('cruds.user.fields.pincode')); ?></label>
                <input class="form-control <?php echo e($errors->has('pincode') ? 'is-invalid' : ''); ?>" type="text" name="pincode" id="pincode" value="<?php echo e(old('pincode', $user->pincode)); ?>">
                <?php if($errors->has('pincode')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('pincode')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.pincode_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="password"><?php echo e(trans('cruds.user.fields.password')); ?></label>
                <input class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" type="password" name="password" id="password">
                <?php if($errors->has('password')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('password')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.password_helper')); ?></span>
            </div>
            <div class="form-group">
                <div class="form-check <?php echo e($errors->has('approved') ? 'is-invalid' : ''); ?>">
                    <input type="hidden" name="approved" value="0">
                    <input class="form-check-input" type="checkbox" name="approved" id="approved" value="1" <?php echo e($user->approved || old('approved', 0) === 1 ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="approved"><?php echo e(trans('cruds.user.fields.approved')); ?></label>
                </div>
                <?php if($errors->has('approved')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('approved')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.approved_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="roles"><?php echo e(trans('cruds.user.fields.roles')); ?></label>
                <div style="padding-bottom: 4px">
                    <span class="btn btn-info btn-xs select-all" style="border-radius: 0"><?php echo e(trans('global.select_all')); ?></span>
                    <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0"><?php echo e(trans('global.deselect_all')); ?></span>
                </div>
                <select class="form-control select2 <?php echo e($errors->has('roles') ? 'is-invalid' : ''); ?>" name="roles[]" id="roles" multiple required>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e((in_array($id, old('roles', [])) || $user->roles->contains($id)) ? 'selected' : ''); ?>><?php echo e($role); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('roles')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('roles')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.roles_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="profile_photo"><?php echo e(trans('cruds.user.fields.profile_photo')); ?></label>
                <div class="needsclick dropzone <?php echo e($errors->has('profile_photo') ? 'is-invalid' : ''); ?>" id="profile_photo-dropzone">
                </div>
                <?php if($errors->has('profile_photo')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('profile_photo')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.user.fields.profile_photo_helper')); ?></span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    <?php echo e(trans('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    Dropzone.options.profilePhotoDropzone = {
    url: '<?php echo e(route('admin.users.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    maxFiles: 1,
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').find('input[name="profile_photo"]').remove()
      $('form').append('<input type="hidden" name="profile_photo" value="' + response.name + '">')
    },
    removedfile: function (file) {
      file.previewElement.remove()
      if (file.status !== 'error') {
        $('form').find('input[name="profile_photo"]').remove()
        this.options.maxFiles = this.options.maxFiles + 1
      }
    },
    init: function () {
<?php if(isset($user) && $user->profile_photo): ?>
      var file = <?php echo json_encode($user->profile_photo); ?>

          this.options.addedfile.call(this, file)
      this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
      file.previewElement.classList.add('dz-complete')
      $('form').append('<input type="hidden" name="profile_photo" value="' + file.file_name + '">')
      this.options.maxFiles = this.options.maxFiles - 1
<?php endif; ?>
    },
    error: function (file, response) {
        if ($.type(response) === 'string') {
            var message = response //dropzone sends it's own error messages in string
        } else {
            var message = response.errors.file
        }
        file.previewElement.classList.add('dz-error')
        _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
        _results = []
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            node = _ref[_i]
            _results.push(node.textContent = message)
        }

        return _results
    }
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>