<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_create')): ?>
                <div style="margin-bottom: 10px;" class="row">
                    <div class="col-lg-12">
                        <a class="btn btn-success" href="<?php echo e(route('frontend.users.create')); ?>">
                            <?php echo e(trans('global.add')); ?> <?php echo e(trans('cruds.user.title_singular')); ?>

                        </a>
                    </div>
                </div>
            <?php endif; ?>
            <div class="card">
                <div class="card-header">
                    <?php echo e(trans('cruds.user.title_singular')); ?> <?php echo e(trans('global.list')); ?>

                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class=" table table-bordered table-striped table-hover datatable datatable-User">
                            <thead>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.id')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.name')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.last_name')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.email')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.gender')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.dob')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.mobile_no')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.address_line_1')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.address_line_2')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.city')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.state')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.coutry')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.pincode')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.email_verified_at')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.approved')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.roles')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(trans('cruds.user.fields.profile_photo')); ?>

                                    </th>
                                    <th>
                                        &nbsp;
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-entry-id="<?php echo e($user->id); ?>">
                                        <td>
                                            <?php echo e($user->id ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->name ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->last_name ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->email ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e(App\Models\User::GENDER_RADIO[$user->gender] ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->dob ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->mobile_no ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->address_line_1 ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->address_line_2 ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->city ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->state ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->coutry ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->pincode ?? ''); ?>

                                        </td>
                                        <td>
                                            <?php echo e($user->email_verified_at ?? ''); ?>

                                        </td>
                                        <td>
                                            <span style="display:none"><?php echo e($user->approved ?? ''); ?></span>
                                            <input type="checkbox" disabled="disabled" <?php echo e($user->approved ? 'checked' : ''); ?>>
                                        </td>
                                        <td>
                                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span><?php echo e($item->title); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td>
                                            <?php if($user->profile_photo): ?>
                                                <a href="<?php echo e($user->profile_photo->getUrl()); ?>" target="_blank" style="display: inline-block">
                                                    <img src="<?php echo e($user->profile_photo->getUrl('thumb')); ?>">
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_show')): ?>
                                                <a class="btn btn-xs btn-primary" href="<?php echo e(route('frontend.users.show', $user->id)); ?>">
                                                    <?php echo e(trans('global.view')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_edit')): ?>
                                                <a class="btn btn-xs btn-info" href="<?php echo e(route('frontend.users.edit', $user->id)); ?>">
                                                    <?php echo e(trans('global.edit')); ?>

                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_delete')): ?>
                                                <form action="<?php echo e(route('frontend.users.destroy', $user->id)); ?>" method="POST" onsubmit="return confirm('<?php echo e(trans('global.areYouSure')); ?>');" style="display: inline-block;">
                                                    <input type="hidden" name="_method" value="DELETE">
                                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                    <input type="submit" class="btn btn-xs btn-danger" value="<?php echo e(trans('global.delete')); ?>">
                                                </form>
                                            <?php endif; ?>

                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_delete')): ?>
  let deleteButtonTrans = '<?php echo e(trans('global.datatables.delete')); ?>'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "<?php echo e(route('frontend.users.massDestroy')); ?>",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('<?php echo e(trans('global.datatables.zero_selected')); ?>')

        return
      }

      if (confirm('<?php echo e(trans('global.areYouSure')); ?>')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
<?php endif; ?>

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-User:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/frontend/users/index.blade.php ENDPATH**/ ?>