
<?php $__env->startSection('content'); ?>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
    }

    .container {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        border: 2px solid #ccc;
    }

    form {
        width: 100%;
        /* max-width: 1000px; */
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 10px;
        background-color: #f9f9f9;
    }

    label, input, select {
        display: block;
        margin-bottom: 10px;
    }

    input[type="submit"] {
        background-color: #4CAF50;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }

    input[type="submit"]:hover {
        background-color: #45a049;
    }

    .new-student-button {
        margin-bottom: 10px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 5px;
        padding: 10px 20px;
        cursor: pointer;
    }

    .email {
        width: 100%;
        padding: 10px;
        font-size: 16px;
        border: 1px solid #ccc;
        border-radius: 5px;
        height: 150px; /* Increased height */
        resize: vertical; /* Allow vertical resizing */
    }

    .student-dropdown {
        width: calc(100% - 120px); /* Adjusted width */
    }

    .student-select-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 10px;
    }
</style>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('cruds.certificates.title_singular')); ?>

    </div>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.certificates.store")); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="form-group row">
            <label for="student" class="col-md-9" style="margin-right: 10px;">Select Student:</label>
            <div class="col-md-9">
                <select class="form-control select2 <?php echo e($errors->has('teacher') ? 'is-invalid' : ''); ?>" name="student_id" id="student_id" required>
                    <option value="">Select Student</option>
                    <?php $__currentLoopData = $studentAll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($entry->id); ?>"><?php echo e($entry->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <button class="btn btn-primary new-student-button">+</button>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-4">
                <label for="refNo">Enter Reference No:</label>
                <input type="text" id="refNo" name="refNo" class="form-control" style="width: 100%; margin-bottom: 10px;" required>
            </div>
            <div class="form-group col-md-4">
                <label for="courseStartDate">Course Start Date:</label>
                <input type="date" id="courseStartDate" name="courseStartDate" class="form-control" required>
            </div>
            <div class="form-group col-md-4">
                <label for="courseEndDate">Course End Date:</label>
                <input type="date" id="courseEndDate" name="courseEndDate" class="form-control" required>
            </div>
        </div>

        <div class="form-row">
    <div class="form-group col-md-4">
        <label for="cerDesign" class="col-form-label">Select Certificate:</label>
        <select id="cerDesign" name="cerDesign" class="form-control" required>
            <option value="">Select Certificate</option>
            <option value="certificate1">Certificate 1</option>
            <option value="certificate2">Certificate 2</option>
            <option value="certificate3">Certificate 3</option>
        </select>
    </div>

    <div class="form-group col-md-4">
        <label for="emailTemplate" class="col-form-label">Select Email Template:</label>
        <select id="emailTemplate" name="emailTemplate" class="form-control" onchange="updateEmailContent()" required>
            <option value="">Select Email Template</option>
            <option value="template1">Email Template 1</option>
            <option value="template2">Email Template 2</option>
            <option value="template3">Email Template 3</option>
        </select>
    </div>

    <div class="form-group col-md-4">
        <label for="email">Email Template:</label>
        <textarea id="emailContent" name="emailContent" class="form-control email" style="margin-bottom: 10px; width: 100%;">Write email here...</textarea>
    </div>
</div>

            <button type="submit" class="btn btn-primary">Send</button>
        </form>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    var uploadedThumbnailMap = {}
Dropzone.options.thumbnailDropzone = {
    url: '<?php echo e(route('admin.courses.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').append('<input type="hidden" name="thumbnail[]" value="' + response.name + '">')
      uploadedThumbnailMap[file.name] = response.name
    },
    removedfile: function (file) {
      console.log(file)
      file.previewElement.remove()
      var name = ''
      if (typeof file.file_name !== 'undefined') {
        name = file.file_name
      } else {
        name = uploadedThumbnailMap[file.name]
      }
      $('form').find('input[name="thumbnail[]"][value="' + name + '"]').remove()
    },
    init: function () {
<?php if(isset($course) && $course->thumbnail): ?>
      var files = <?php echo json_encode($course->thumbnail); ?>

          for (var i in files) {
          var file = files[i]
          this.options.addedfile.call(this, file)
          this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
          file.previewElement.classList.add('dz-complete')
          $('form').append('<input type="hidden" name="thumbnail[]" value="' + file.file_name + '">')
        }
<?php endif; ?>
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}

 
    function updateEmailContent() {
        var selectedTemplate = document.getElementById('emailTemplate').value;
        var templateContent = '';

        var html1 = `<p>Hello2 stuName,</p>
    <p>Congratulations! We are pleased to inform you that you have successfully passed the <strong>Example Course</strong> course, which took place from <strong>Example Start Date - Example End Date</strong>. Your hard work and dedication have paid off, and we commend you for your achievement.</p>
    <p>Your reference number for this course is: <strong>Example Ref No</strong></p>
    <p>To download your certificate, please visit the following link: <a href="https://example.com/verification">example.com/verification</a>. Enter your reference number to access and download your certificate.</p>
    <p>Once again, congratulations on your accomplishment. We wish you continued success in your future endeavors.</p>
    <p>Best regards,</p>
    <p>Example Global</p>`;

    var html2 = `<p>Hello2 stuName,</p>
    <p>Congratulations! We are pleased to inform you that you have successfully passed the <strong>Example Course</strong> course, which took place from <strong>Example Start Date - Example End Date</strong>. Your hard work and dedication have paid off, and we commend you for your achievement.</p>
    <p>Your reference number for this course is: <strong>Example Ref No</strong></p>
    <p>To download your certificate, please visit the following link: <a href="https://example.com/verification">example.com/verification</a>. Enter your reference number to access and download your certificate.</p>
    <p>Once again, congratulations on your accomplishment. We wish you continued success in your future endeavors.</p>
    <p>Best regards,</p>
    <p>Example Global</p>`;

    var html3 = `<p>Hello3 stuName,</p>
    <p>Congratulations! We are pleased to inform you that you have successfully passed the <strong>Example Course</strong> course, which took place from <strong>Example Start Date - Example End Date</strong>. Your hard work and dedication have paid off, and we commend you for your achievement.</p>
    <p>Your reference number for this course is: <strong>Example Ref No</strong></p>
    <p>To download your certificate, please visit the following link: <a href="https://example.com/verification">example.com/verification</a>. Enter your reference number to access and download your certificate.</p>
    <p>Once again, congratulations on your accomplishment. We wish you continued success in your future endeavors.</p>
    <p>Best regards,</p>
    <p>Example Global</p>`;

        switch (selectedTemplate) {
            case 'template1':
                templateContent = html1;
                break;
            case 'template2':
                templateContent = html2;
                break;
            case 'template3':
                templateContent = html3;
                break;
            default:
                templateContent = '';
        }

        document.getElementById('emailContent').value = templateContent;
    }


    $(document).ready(function () {
        // Add change event listener to 'courseStartDate'
        $('#courseStartDate').change(function () {
            validateDateInputs();
        });

        // Add change event listener to 'courseEndDate'
        $('#courseEndDate').change(function () {
            validateDateInputs();
        });

        function validateDateInputs() {
            // Get the values of 'courseStartDate' and 'courseEndDate'
            var startDate = $('#courseStartDate').val();
            var endDate = $('#courseEndDate').val();

            // Check if 'courseEndDate' is greater than 'courseStartDate'
            if (startDate && endDate && startDate > endDate) {
                alert('Course End Date should be greater than Course Start Date.');
                // Optionally, you can clear the 'courseEndDate' field or take other actions
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\lgb1\LCBGlobal\resources\views/admin/certificates/create.blade.php ENDPATH**/ ?>