<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('cruds.course.title_singular')); ?>

    </div>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.courses.store")); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label class="required" for="teacher_id"><?php echo e(trans('cruds.course.fields.teacher')); ?></label>
                <select class="form-control select2 <?php echo e($errors->has('teacher') ? 'is-invalid' : ''); ?>" name="teacher_id" id="teacher_id" required>
                    <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e(old('teacher_id') == $id ? 'selected' : ''); ?>><?php echo e($entry); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('teacher')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('teacher')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.teacher_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="title"><?php echo e(trans('cruds.course.fields.title')); ?></label>
                <input class="form-control <?php echo e($errors->has('title') ? 'is-invalid' : ''); ?>" type="text" name="title" id="title" value="<?php echo e(old('title', '')); ?>" required>
                <?php if($errors->has('title')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('title')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.title_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="description"><?php echo e(trans('cruds.course.fields.description')); ?></label>
                <textarea class="form-control <?php echo e($errors->has('description') ? 'is-invalid' : ''); ?>" name="description" id="description" required><?php echo e(old('description')); ?></textarea>
                <?php if($errors->has('description')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('description')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.description_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="price"><?php echo e(trans('cruds.course.fields.price')); ?></label>
                <input class="form-control <?php echo e($errors->has('price') ? 'is-invalid' : ''); ?>" type="number" name="price" id="price" value="<?php echo e(old('price', '')); ?>" step="0.01">
                <?php if($errors->has('price')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('price')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.price_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="thumbnail"><?php echo e(trans('cruds.course.fields.thumbnail')); ?></label>
                <div class="needsclick dropzone <?php echo e($errors->has('thumbnail') ? 'is-invalid' : ''); ?>" id="thumbnail-dropzone">
                </div>
                <?php if($errors->has('thumbnail')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('thumbnail')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.thumbnail_helper')); ?></span>
            </div>
            <div class="form-group">
                <div class="form-check <?php echo e($errors->has('is_published') ? 'is-invalid' : ''); ?>">
                    <input type="hidden" name="is_published" value="0">
                    <input class="form-check-input" type="checkbox" name="is_published" id="is_published" value="1" <?php echo e(old('is_published', 0) == 1 ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="is_published"><?php echo e(trans('cruds.course.fields.is_published')); ?></label>
                </div>
                <?php if($errors->has('is_published')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('is_published')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.is_published_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="students"><?php echo e(trans('cruds.course.fields.students')); ?></label>
                <div style="padding-bottom: 4px">
                    <span class="btn btn-info btn-xs select-all" style="border-radius: 0"><?php echo e(trans('global.select_all')); ?></span>
                    <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0"><?php echo e(trans('global.deselect_all')); ?></span>
                </div>
                <select class="form-control select2 <?php echo e($errors->has('students') ? 'is-invalid' : ''); ?>" name="students[]" id="students" multiple>
                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e(in_array($id, old('students', [])) ? 'selected' : ''); ?>><?php echo e($student); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('students')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('students')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.students_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="level"><?php echo e(trans('cruds.course.fields.level')); ?></label>
                <input class="form-control <?php echo e($errors->has('level') ? 'is-invalid' : ''); ?>" type="text" name="level" id="level" value="<?php echo e(old('level', '')); ?>">
                <?php if($errors->has('level')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('level')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.level_helper')); ?></span>
            </div>
            <div class="form-group">
                <label><?php echo e(trans('cruds.course.fields.accreditation_status')); ?></label>
                <select class="form-control <?php echo e($errors->has('accreditation_status') ? 'is-invalid' : ''); ?>" name="accreditation_status" id="accreditation_status">
                    <option value disabled <?php echo e(old('accreditation_status', null) === null ? 'selected' : ''); ?>><?php echo e(trans('global.pleaseSelect')); ?></option>
                    <?php $__currentLoopData = App\Models\Course::ACCREDITATION_STATUS_SELECT; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e(old('accreditation_status', '') === (string) $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('accreditation_status')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('accreditation_status')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.accreditation_status_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="credit_equivalency"><?php echo e(trans('cruds.course.fields.credit_equivalency')); ?></label>
                <input class="form-control <?php echo e($errors->has('credit_equivalency') ? 'is-invalid' : ''); ?>" type="text" name="credit_equivalency" id="credit_equivalency" value="<?php echo e(old('credit_equivalency', '')); ?>">
                <?php if($errors->has('credit_equivalency')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('credit_equivalency')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.credit_equivalency_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="qualification_number"><?php echo e(trans('cruds.course.fields.qualification_number')); ?></label>
                <input class="form-control <?php echo e($errors->has('qualification_number') ? 'is-invalid' : ''); ?>" type="text" name="qualification_number" id="qualification_number" value="<?php echo e(old('qualification_number', '')); ?>">
                <?php if($errors->has('qualification_number')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('qualification_number')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.qualification_number_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="progression_routes"><?php echo e(trans('cruds.course.fields.progression_routes')); ?></label>
                <input class="form-control <?php echo e($errors->has('progression_routes') ? 'is-invalid' : ''); ?>" type="text" name="progression_routes" id="progression_routes" value="<?php echo e(old('progression_routes', '')); ?>">
                <?php if($errors->has('progression_routes')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('progression_routes')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.progression_routes_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="availability"><?php echo e(trans('cruds.course.fields.availability')); ?></label>
                <input class="form-control <?php echo e($errors->has('availability') ? 'is-invalid' : ''); ?>" type="text" name="availability" id="availability" value="<?php echo e(old('availability', '')); ?>">
                <?php if($errors->has('availability')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('availability')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.course.fields.availability_helper')); ?></span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    <?php echo e(trans('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    var uploadedThumbnailMap = {}
Dropzone.options.thumbnailDropzone = {
    url: '<?php echo e(route('admin.courses.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').append('<input type="hidden" name="thumbnail[]" value="' + response.name + '">')
      uploadedThumbnailMap[file.name] = response.name
    },
    removedfile: function (file) {
      console.log(file)
      file.previewElement.remove()
      var name = ''
      if (typeof file.file_name !== 'undefined') {
        name = file.file_name
      } else {
        name = uploadedThumbnailMap[file.name]
      }
      $('form').find('input[name="thumbnail[]"][value="' + name + '"]').remove()
    },
    init: function () {
<?php if(isset($course) && $course->thumbnail): ?>
      var files = <?php echo json_encode($course->thumbnail); ?>

          for (var i in files) {
          var file = files[i]
          this.options.addedfile.call(this, file)
          this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
          file.previewElement.classList.add('dz-complete')
          $('form').append('<input type="hidden" name="thumbnail[]" value="' + file.file_name + '">')
        }
<?php endif; ?>
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/admin/courses/create.blade.php ENDPATH**/ ?>