<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('cruds.question.title_singular')); ?>

    </div>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.questions.store")); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="test_id"><?php echo e(trans('cruds.question.fields.test')); ?></label>
                <select class="form-control select2 <?php echo e($errors->has('test') ? 'is-invalid' : ''); ?>" name="test_id" id="test_id">
                    <?php $__currentLoopData = $tests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e(old('test_id') == $id ? 'selected' : ''); ?>><?php echo e($entry); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('test')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('test')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.question.fields.test_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="question_text"><?php echo e(trans('cruds.question.fields.question_text')); ?></label>
                <input class="form-control <?php echo e($errors->has('question_text') ? 'is-invalid' : ''); ?>" type="text" name="question_text" id="question_text" value="<?php echo e(old('question_text', '')); ?>" required>
                <?php if($errors->has('question_text')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('question_text')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.question.fields.question_text_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="question_image"><?php echo e(trans('cruds.question.fields.question_image')); ?></label>
                <div class="needsclick dropzone <?php echo e($errors->has('question_image') ? 'is-invalid' : ''); ?>" id="question_image-dropzone">
                </div>
                <?php if($errors->has('question_image')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('question_image')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.question.fields.question_image_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="points"><?php echo e(trans('cruds.question.fields.points')); ?></label>
                <input class="form-control <?php echo e($errors->has('points') ? 'is-invalid' : ''); ?>" type="number" name="points" id="points" value="<?php echo e(old('points', '1')); ?>" step="1">
                <?php if($errors->has('points')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('points')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.question.fields.points_helper')); ?></span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    <?php echo e(trans('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    Dropzone.options.questionImageDropzone = {
    url: '<?php echo e(route('admin.questions.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    maxFiles: 1,
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').find('input[name="question_image"]').remove()
      $('form').append('<input type="hidden" name="question_image" value="' + response.name + '">')
    },
    removedfile: function (file) {
      file.previewElement.remove()
      if (file.status !== 'error') {
        $('form').find('input[name="question_image"]').remove()
        this.options.maxFiles = this.options.maxFiles + 1
      }
    },
    init: function () {
<?php if(isset($question) && $question->question_image): ?>
      var file = <?php echo json_encode($question->question_image); ?>

          this.options.addedfile.call(this, file)
      this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
      file.previewElement.classList.add('dz-complete')
      $('form').append('<input type="hidden" name="question_image" value="' + file.file_name + '">')
      this.options.maxFiles = this.options.maxFiles - 1
<?php endif; ?>
    },
    error: function (file, response) {
        if ($.type(response) === 'string') {
            var message = response //dropzone sends it's own error messages in string
        } else {
            var message = response.errors.file
        }
        file.previewElement.classList.add('dz-error')
        _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
        _results = []
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            node = _ref[_i]
            _results.push(node.textContent = message)
        }

        return _results
    }
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/admin/questions/create.blade.php ENDPATH**/ ?>