<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.show')); ?> <?php echo e(trans('cruds.course.title')); ?>

    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="<?php echo e(route('admin.courses.index')); ?>">
                    <?php echo e(trans('global.back_to_list')); ?>

                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.id')); ?>

                        </th>
                        <td>
                            <?php echo e($course->id); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.teacher')); ?>

                        </th>
                        <td>
                            <?php echo e($course->teacher->name ?? ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.title')); ?>

                        </th>
                        <td>
                            <?php echo e($course->title); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.description')); ?>

                        </th>
                        <td>
                            <?php echo e($course->description); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.price')); ?>

                        </th>
                        <td>
                            <?php echo e($course->price); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.thumbnail')); ?>

                        </th>
                        <td>
                            <?php $__currentLoopData = $course->thumbnail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e($media->getUrl()); ?>" target="_blank" style="display: inline-block">
                                    <img src="<?php echo e($media->getUrl('thumb')); ?>">
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.is_published')); ?>

                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" <?php echo e($course->is_published ? 'checked' : ''); ?>>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.students')); ?>

                        </th>
                        <td>
                            <?php $__currentLoopData = $course->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $students): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="label label-info"><?php echo e($students->name); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.level')); ?>

                        </th>
                        <td>
                            <?php echo e($course->level); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.accreditation_status')); ?>

                        </th>
                        <td>
                            <?php echo e(App\Models\Course::ACCREDITATION_STATUS_SELECT[$course->accreditation_status] ?? ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.credit_equivalency')); ?>

                        </th>
                        <td>
                            <?php echo e($course->credit_equivalency); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.qualification_number')); ?>

                        </th>
                        <td>
                            <?php echo e($course->qualification_number); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.progression_routes')); ?>

                        </th>
                        <td>
                            <?php echo e($course->progression_routes); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>
                            <?php echo e(trans('cruds.course.fields.availability')); ?>

                        </th>
                        <td>
                            <?php echo e($course->availability); ?>

                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="<?php echo e(route('admin.courses.index')); ?>">
                    <?php echo e(trans('global.back_to_list')); ?>

                </a>
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/admin/courses/show.blade.php ENDPATH**/ ?>