<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.edit')); ?> <?php echo e(trans('cruds.lesson.title_singular')); ?>

    </div>

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.lessons.update", [$lesson->id])); ?>" enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label class="required" for="course_id"><?php echo e(trans('cruds.lesson.fields.course')); ?></label>
                <select class="form-control select2 <?php echo e($errors->has('course') ? 'is-invalid' : ''); ?>" name="course_id" id="course_id" required>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e((old('course_id') ? old('course_id') : $lesson->course->id ?? '') == $id ? 'selected' : ''); ?>><?php echo e($entry); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('course')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('course')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.course_helper')); ?></span>
            </div>
            <div class="form-group">
                <label class="required" for="title"><?php echo e(trans('cruds.lesson.fields.title')); ?></label>
                <input class="form-control <?php echo e($errors->has('title') ? 'is-invalid' : ''); ?>" type="text" name="title" id="title" value="<?php echo e(old('title', $lesson->title)); ?>" required>
                <?php if($errors->has('title')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('title')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.title_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="thumbnail"><?php echo e(trans('cruds.lesson.fields.thumbnail')); ?></label>
                <div class="needsclick dropzone <?php echo e($errors->has('thumbnail') ? 'is-invalid' : ''); ?>" id="thumbnail-dropzone">
                </div>
                <?php if($errors->has('thumbnail')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('thumbnail')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.thumbnail_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="short_text"><?php echo e(trans('cruds.lesson.fields.short_text')); ?></label>
                <textarea class="form-control <?php echo e($errors->has('short_text') ? 'is-invalid' : ''); ?>" name="short_text" id="short_text"><?php echo e(old('short_text', $lesson->short_text)); ?></textarea>
                <?php if($errors->has('short_text')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('short_text')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.short_text_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="long_text"><?php echo e(trans('cruds.lesson.fields.long_text')); ?></label>
                <textarea class="form-control <?php echo e($errors->has('long_text') ? 'is-invalid' : ''); ?>" name="long_text" id="long_text"><?php echo e(old('long_text', $lesson->long_text)); ?></textarea>
                <?php if($errors->has('long_text')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('long_text')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.long_text_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="video"><?php echo e(trans('cruds.lesson.fields.video')); ?></label>
                <div class="needsclick dropzone <?php echo e($errors->has('video') ? 'is-invalid' : ''); ?>" id="video-dropzone">
                </div>
                <?php if($errors->has('video')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('video')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.video_helper')); ?></span>
            </div>
            <div class="form-group">
                <label for="position"><?php echo e(trans('cruds.lesson.fields.position')); ?></label>
                <input class="form-control <?php echo e($errors->has('position') ? 'is-invalid' : ''); ?>" type="number" name="position" id="position" value="<?php echo e(old('position', $lesson->position)); ?>" step="1">
                <?php if($errors->has('position')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('position')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.position_helper')); ?></span>
            </div>
            <div class="form-group">
                <div class="form-check <?php echo e($errors->has('is_published') ? 'is-invalid' : ''); ?>">
                    <input type="hidden" name="is_published" value="0">
                    <input class="form-check-input" type="checkbox" name="is_published" id="is_published" value="1" <?php echo e($lesson->is_published || old('is_published', 0) === 1 ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="is_published"><?php echo e(trans('cruds.lesson.fields.is_published')); ?></label>
                </div>
                <?php if($errors->has('is_published')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('is_published')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.is_published_helper')); ?></span>
            </div>
            <div class="form-group">
                <div class="form-check <?php echo e($errors->has('is_free') ? 'is-invalid' : ''); ?>">
                    <input type="hidden" name="is_free" value="0">
                    <input class="form-check-input" type="checkbox" name="is_free" id="is_free" value="1" <?php echo e($lesson->is_free || old('is_free', 0) === 1 ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="is_free"><?php echo e(trans('cruds.lesson.fields.is_free')); ?></label>
                </div>
                <?php if($errors->has('is_free')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('is_free')); ?>

                    </div>
                <?php endif; ?>
                <span class="help-block"><?php echo e(trans('cruds.lesson.fields.is_free_helper')); ?></span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    <?php echo e(trans('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    var uploadedThumbnailMap = {}
Dropzone.options.thumbnailDropzone = {
    url: '<?php echo e(route('admin.lessons.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').append('<input type="hidden" name="thumbnail[]" value="' + response.name + '">')
      uploadedThumbnailMap[file.name] = response.name
    },
    removedfile: function (file) {
      console.log(file)
      file.previewElement.remove()
      var name = ''
      if (typeof file.file_name !== 'undefined') {
        name = file.file_name
      } else {
        name = uploadedThumbnailMap[file.name]
      }
      $('form').find('input[name="thumbnail[]"][value="' + name + '"]').remove()
    },
    init: function () {
<?php if(isset($lesson) && $lesson->thumbnail): ?>
      var files = <?php echo json_encode($lesson->thumbnail); ?>

          for (var i in files) {
          var file = files[i]
          this.options.addedfile.call(this, file)
          this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
          file.previewElement.classList.add('dz-complete')
          $('form').append('<input type="hidden" name="thumbnail[]" value="' + file.file_name + '">')
        }
<?php endif; ?>
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}

</script>
<script>
    Dropzone.options.videoDropzone = {
    url: '<?php echo e(route('admin.lessons.storeMedia')); ?>',
    maxFilesize: 2, // MB
    maxFiles: 1,
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2
    },
    success: function (file, response) {
      $('form').find('input[name="video"]').remove()
      $('form').append('<input type="hidden" name="video" value="' + response.name + '">')
    },
    removedfile: function (file) {
      file.previewElement.remove()
      if (file.status !== 'error') {
        $('form').find('input[name="video"]').remove()
        this.options.maxFiles = this.options.maxFiles + 1
      }
    },
    init: function () {
<?php if(isset($lesson) && $lesson->video): ?>
      var file = <?php echo json_encode($lesson->video); ?>

          this.options.addedfile.call(this, file)
      file.previewElement.classList.add('dz-complete')
      $('form').append('<input type="hidden" name="video" value="' + file.file_name + '">')
      this.options.maxFiles = this.options.maxFiles - 1
<?php endif; ?>
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcbglob/public_html/admin/resources/views/admin/lessons/edit.blade.php ENDPATH**/ ?>