
<?php $__env->startSection('content'); ?>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
    }

    .container {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        border: 2px solid #ccc;
    }

    form {
        width: 100%;
        /* max-width: 1000px; */
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 10px;
        background-color: #f9f9f9;
    }

    label, input, select {
        display: block;
        margin-bottom: 10px;
    }

    input[type="submit"] {
        background-color: #4CAF50;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }

    input[type="submit"]:hover {
        background-color: #45a049;
    }

    .new-student-button {
        margin-bottom: 10px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 5px;
        padding: 10px 20px;
        cursor: pointer;
    }

    .email {
        width: 100%;
        padding: 10px;
        font-size: 16px;
        border: 1px solid #ccc;
        border-radius: 5px;
        height: 150px; /* Increased height */
        resize: vertical; /* Allow vertical resizing */
    }

    .student-dropdown {
        width: calc(100% - 120px); /* Adjusted width */
    }

    .student-select-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 10px;
    }

</style>
<style>
    #popupForm {
     z-index: 1000; 
    }
    .popup {
    z-index: 1000; 
    }
    .overlay1 {
    z-index: 900; 
    }
    .overlay {
    z-index: 900; 
    }
    body {
      font-family: Arial, sans-serif;
    }
    .popup {
      display: none;
      position: fixed;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      padding: 20px;
      background-color: #fff;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      z-index: 1000;
      max-width: 600px; /* Adjust the max-width as needed */
      width: 100%;
      box-sizing: border-box;
    }

    .form-group {
      margin-bottom: 15px;
    }

    label {
      display: block;
      margin-bottom: 5px;
    }

    input,
    select,
    button {
      width: 100%;
      padding: 6px;
      box-sizing: border-box;
    }

    .form-group-half {
      display: inline-block;
      width: calc(50% - 5px); /* Adjust the width and margin as needed */
      box-sizing: border-box;
    }

    button {
      padding: 10px;
      background-color: #007BFF;
      color: #fff;
      border: none;
      cursor: pointer;
    }

    button:hover {
      background-color: #0056b3;
    }

    .row-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      background-color: #f0f0f0;
      padding: 10px;
       /* Adjust as needed */
    }

    /* Style for the "Add Student" heading */
    h3 {
      margin: 0;
      font-size: 15px;
    }

    /* Style for the close button */
    .close-btn {
      cursor: pointer;
      background-color: #ff0000; /* Adjust as needed */
      color: #ffffff; /* Adjust as needed */
      border: none;
      border-radius: 50%; /* Creates a circular shape */
      padding: 5px 10px;
      font-size: 12px;
    }
  
    .form-group {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .edit-button {
        margin-left: 10px;
    }

    #popupForm {
        display: none;
        position: fixed;
        top: 70%;
        left: 50%;
        transform: translate(-50%, -50%);
        background-color: #fff;
        padding: 20px;
        border: 1px solid #ccc;
        z-index: 1000;
    }
</style>


<div id="studentPopup" class="popup">
<div class="row-container">
  <h3>Add Student</h3>
  <span class="close-btn" onclick="closePopup()">X</span>
</div>
 
  <div class="row">
    <div class="col-md-6">
      <div class="form-group">
        <label for="firstName">First Name:</label>
        <input type="text" id="firstName" required>
      </div>
      <div class="form-group">
        <label for="email">Email:</label>
        <input type="email" id="email" required>
      </div>
      <div class="form-group">
        <label for="dob">Date of Birth:</label>
        <input type="date" id="dob" required>
      </div>
      <div class="form-group">
        <label for="addressLine1">Address Line 1:</label>
        <input type="text" id="addressLine1" required>
      </div>
       
      
     
    </div>
    <div class="col-md-6">
      <div class="form-group">
        <label for="lastName">Last Name:</label>
        <input type="text" id="lastName" required>
      </div>
      <div class="form-group">
        <label for="gender">Gender:</label>
        <select id="gender" required>
          <option value="male">Male</option>
          <option value="female">Female</option>
          <option value="other">Other</option>
        </select>
      </div>
      <div class="form-group">
        <label for="mobileNo">Mobile Number:</label>
        <input type="tel" id="mobileNo" required>
      </div>
      <div class="form-group">
        <label for="addressLine2">Address Line 2:</label>
        <input type="text" id="addressLine2">
      </div>
       
     
      <div class="form-group">
        <label for="password">Password:</label>
        <input type="password" id="password" required>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-6">
      <button onclick="addStudent()">Add Student</button>
    </div>
    <div class="col-md-6">
      <button onclick="closePopup()">Cancel</button>
    </div>
  </div>
</div>


<div id="popupForm" class="modal popup">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Certificate Email</h5>
                <span class="close-btn" onclick="closePopup1()">X</span>
            </div>
            <div class="modal-body">
                <label for="emailSubject">Email Subject:</label>
                <input type="text" id="emailSubject" name="emailSubject" value="" class="form-control"><br>
                <label for="emailContent">Email Content:</label>
                <textarea id="emailContent" name="emailContent" class="form-control"></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="updateEmailCertificate">Update</button>
            </div>
        </div>
    </div>
</div>

<div id="overlay" class="overlay" onclick="closePopup()"></div>
<div id="overlay1" class="overlay1" onclick="closePopup1()"></div>


<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('cruds.certificates.title_singular')); ?>

    </div>

    

    <div class="card-body">
        <form method="POST" action="<?php echo e(route("admin.certificates.store")); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="form-group row">
            <label for="student" class="col-md-9" style="margin-right: 10px;">Select Student:</label>
            <div class="col-md-9">
                <select class="form-control select2 <?php echo e($errors->has('teacher') ? 'is-invalid' : ''); ?>" name="student_id" id="student_id" required>
                    <option value="">Select Student</option>
                    <?php $__currentLoopData = $studentAll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($entry->id); ?>"><?php echo e($entry->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <button onclick="openPopup()" class="btn btn-primary new-student-button">+</button>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-4">
                <label for="refNo">Enter Reference No:</label>
                <input type="text" id="refNo" name="refNo" class="form-control" style="width: 100%; margin-bottom: 10px;" required>
            </div>
            <div class="form-group col-md-4">
                <label for="courseStartDate">Course Start Date:</label>
                <input type="date" id="courseStartDate" name="courseStartDate" class="form-control" required>
            </div>
            <div class="form-group col-md-4">
                <label for="courseEndDate">Course End Date:</label>
                <input type="date" id="courseEndDate" name="courseEndDate" class="form-control" required>
            </div>
        </div>

        <div class="form-row">
    <div class="form-group col-md-4">
        <label for="cerDesign" class="col-form-label">Select Certificate:</label>
        <select id="cerDesign" name="cerDesign" class="form-control" required>
            <option value="">Select Certificate</option>
            <option value="certificate1">Certificate 1</option>
        </select>
    </div>
  
    <div class="form-group col-md-6 ">
        <label for="emailTemplate" class="col-form-label me-2">Select Email Template:</label>
         <a href="#" class="me-2" onclick="openPopup1()">Edit</a>
        <select id="emailTemplate" name="emailTemplate" class="ms-2 form-control" onchange="updateEmailContent()" required>
            <option value="">Select Email Template</option>
            <option value="template1">Certificate Template </option>
        </select>
    </div>

    
</div>



            <button type="submit" class="btn btn-primary">Send</button>
        </form>
    </div>
</div>
 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    

    var uploadedThumbnailMap = {}
Dropzone.options.thumbnailDropzone = {
    url: '<?php echo e(route('admin.courses.storeMedia')); ?>',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').append('<input type="hidden" name="thumbnail[]" value="' + response.name + '">')
      uploadedThumbnailMap[file.name] = response.name
    },
    removedfile: function (file) {
      console.log(file)
      file.previewElement.remove()
      var name = ''
      if (typeof file.file_name !== 'undefined') {
        name = file.file_name
      } else {
        name = uploadedThumbnailMap[file.name]
      }
      $('form').find('input[name="thumbnail[]"][value="' + name + '"]').remove()
    },
    init: function () {
<?php if(isset($course) && $course->thumbnail): ?>
      var files = <?php echo json_encode($course->thumbnail); ?>

          for (var i in files) {
          var file = files[i]
          this.options.addedfile.call(this, file)
          this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
          file.previewElement.classList.add('dz-complete')
          $('form').append('<input type="hidden" name="thumbnail[]" value="' + file.file_name + '">')
        }
<?php endif; ?>
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}

 
    function updateEmailContent() {
        var selectedTemplate = document.getElementById('emailTemplate').value;
        var templateContent = '';

        var html1 = `<p>Hello2 stuName,</p>
    <p>Congratulations! We are pleased to inform you that you have successfully passed the <strong>Example Course</strong> course, which took place from <strong>Example Start Date - Example End Date</strong>. Your hard work and dedication have paid off, and we commend you for your achievement.</p>
    <p>Your reference number for this course is: <strong>Example Ref No</strong></p>
    <p>To download your certificate, please visit the following link: <a href="https://example.com/verification">example.com/verification</a>. Enter your reference number to access and download your certificate.</p>
    <p>Once again, congratulations on your accomplishment. We wish you continued success in your future endeavors.</p>
    <p>Best regards,</p>
    <p>Example Global</p>`;

    var html2 = `<p>Hello2 stuName,</p>
    <p>Congratulations! We are pleased to inform you that you have successfully passed the <strong>Example Course</strong> course, which took place from <strong>Example Start Date - Example End Date</strong>. Your hard work and dedication have paid off, and we commend you for your achievement.</p>
    <p>Your reference number for this course is: <strong>Example Ref No</strong></p>
    <p>To download your certificate, please visit the following link: <a href="https://example.com/verification">example.com/verification</a>. Enter your reference number to access and download your certificate.</p>
    <p>Once again, congratulations on your accomplishment. We wish you continued success in your future endeavors.</p>
    <p>Best regards,</p>
    <p>Example Global</p>`;

    var html3 = `<p>Hello3 stuName,</p>
    <p>Congratulations! We are pleased to inform you that you have successfully passed the <strong>Example Course</strong> course, which took place from <strong>Example Start Date - Example End Date</strong>. Your hard work and dedication have paid off, and we commend you for your achievement.</p>
    <p>Your reference number for this course is: <strong>Example Ref No</strong></p>
    <p>To download your certificate, please visit the following link: <a href="https://example.com/verification">example.com/verification</a>. Enter your reference number to access and download your certificate.</p>
    <p>Once again, congratulations on your accomplishment. We wish you continued success in your future endeavors.</p>
    <p>Best regards,</p>
    <p>Example Global</p>`;

        switch (selectedTemplate) {
            case 'template1':
                templateContent = html1;
                break;
            case 'template2':
                templateContent = html2;
                break;
            case 'template3':
                templateContent = html3;
                break;
            default:
                templateContent = '';
        }

        document.getElementById('emailContent').value = templateContent;
    }


    $(document).ready(function () {
        // Add change event listener to 'courseStartDate'
        $('#courseStartDate').change(function () {
            validateDateInputs();
        });

        // Add change event listener to 'courseEndDate'
        $('#courseEndDate').change(function () {
            validateDateInputs();
        });

        function validateDateInputs() {
            // Get the values of 'courseStartDate' and 'courseEndDate'
            var startDate = $('#courseStartDate').val();
            var endDate = $('#courseEndDate').val();

            // Check if 'courseEndDate' is greater than 'courseStartDate'
            if (startDate && endDate && startDate > endDate) {
                alert('Course End Date should be greater than Course Start Date.');
                // Optionally, you can clear the 'courseEndDate' field or take other actions
            }
        }
    });


    function openPopup() {
    document.getElementById('studentPopup').style.display = 'block';
    document.getElementById('overlay').style.display = 'block';
  }


  function closePopup() {
    document.getElementById('studentPopup').style.display = 'none';
    document.getElementById('overlay').style.display = 'none';
  }

  function closePopup1() {
    document.getElementById('popupForm').style.display = 'none';
    document.getElementById('overlay1').style.display = 'none';
  }

  function openPopup1() {
    // document.getElementById('popupForm').style.display = 'block';
    // document.getElementById('overlay1').style.display = 'block';
    fetch('http://localhost:8000/admin/certificates/getEmailCertificate', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        $('#emailSubject').val(data?.rs?.subject)
        $('#emailContent').val(data?.rs?.email_content)
        document.getElementById('popupForm').style.display = 'block';
        document.getElementById('overlay1').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });
}


  function addStudent() {
    var firstName = document.getElementById("firstName").value;
    var lastName = document.getElementById("lastName").value;
    var email = document.getElementById("email").value;
    var dob = document.getElementById("dob").value;
    var gender = document.getElementById("gender").value;
    var mobileNo = document.getElementById("mobileNo").value;
    var addressLine1 = document.getElementById("addressLine1").value;
    var addressLine2 = document.getElementById("addressLine2").value;
    var password = document.getElementById("password").value;
 
    var formData = {
        firstName: firstName,
        lastName: lastName,
        email: email,
        dob: dob,
        gender: gender,
        mobileNo: mobileNo,
        addressLine1: addressLine1,
        addressLine2: addressLine2,
        password: password
    };

    fetch('http://localhost:8000/admin/certificates/stuStore', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify(formData)
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        if (data.is_error === 1) {
            alert(data.message);
        } else {
            alert(data.message);
            closePopup();
            location.reload();
        }
    })
    .catch(error => {
        alert("Error adding student. Please try again.");
        console.error('There was a problem with the fetch operation:', error);
    });
}

</script>

<script>
    // Get references to the form elements
    const emailSubjectInput = document.getElementById('emailSubject');
    const emailContentTextarea = document.getElementById('emailContent');
    const updateEmailCertificateBtn = document.getElementById('updateEmailCertificate');

    // Event listener for the "Update" button click
    updateEmailCertificateBtn.addEventListener('click', function() {
        // Get the values from the form fields
        const emailSubject = emailSubjectInput.value;
        const emailContent = emailContentTextarea.value;

        // Prepare the data to be sent
        const data = {
            emailSubject: emailSubject,
            emailContent: emailContent
        };

        // Assuming you want to send the data via fetch
        const url = 'http://localhost:8000/admin/certificates/updateEmailCertificate';
        fetch(url, {
            method: 'POST', // Assuming you want to send the data via POST
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': getCSRFToken()
            },
            body: JSON.stringify(data)
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(responseData => {
            // Handle the response data as needed
            alert("Certificate Email Updated");
            closePopup1();
            console.log('Response:', responseData);
        })
        .catch(error => {
            console.error('Error:', error);
        });
    });

    // Function to retrieve CSRF token from meta tag
    function getCSRFToken() {
        return document.querySelector('meta[name="csrf-token"]').content;
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\lgb1\LCBGlobal\resources\views/admin/certificates/create.blade.php ENDPATH**/ ?>