<?php

Route::group(['prefix' => 'v1', 'as' => 'api.', 'namespace' => 'Api\V1\Admin', 'middleware' => ['auth:sanctum']], function () {
    // Teaches
    Route::post('teaches/media', 'TeachesApiController@storeMedia')->name('teaches.storeMedia');
    Route::apiResource('teaches', 'TeachesApiController');

    // Department
    Route::apiResource('departments', 'DepartmentApiController');

    // Locations
    Route::apiResource('locations', 'LocationsApiController');

    // Gallery
    Route::post('galleries/media', 'GalleryApiController@storeMedia')->name('galleries.storeMedia');
    Route::apiResource('galleries', 'GalleryApiController');

    // Events
    Route::post('events/media', 'EventsApiController@storeMedia')->name('events.storeMedia');
    Route::apiResource('events', 'EventsApiController');
});
