<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ trans('panel.site_title') }}</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet" />
    <link href="https://use.fontawesome.com/releases/v5.2.0/css/all.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/buttons/1.2.4/css/buttons.dataTables.min.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/select/1.3.0/css/select.dataTables.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css" rel="stylesheet" />
    <link href="https://unpkg.com/@coreui/coreui@3.2/dist/css/coreui.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.1/min/dropzone.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/jquery.perfect-scrollbar/1.5.0/css/perfect-scrollbar.min.css" rel="stylesheet" />
    <link href="{{ asset('css/custom.css') }}" rel="stylesheet" />
    @yield('styles')
</head>

<body class="c-app">
    @include('partials.usermenu')
 

      <div class="container mt-5">
        <div class="row justify-content-center">
          <div class="col-md-12">
      
            <div class="card">
              <div class="card-header">
                {{ trans('global.edit') }} {{ trans('global.my_profile') }}
              </div>
      
              <div class="card-body">
                <form method="POST" action="{{ route("frontend.profile.edit") }}" enctype="multipart/form-data">
                  @method('PUT')
                  @csrf
                  <div class="form-group">
                    <label class="required" for="name">{{ trans('cruds.user.fields.name') }}</label>
                    <input class="form-control" type="text" name="name" id="name" value="{{ old('name', $user->name) }}"
                      required>
                    @if($errors->has('name'))
                    <div class="invalid-feedback">
                      {{ $errors->first('name') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.name_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label class="required" for="last_name">{{ trans('cruds.user.fields.last_name') }}</label>
                    <input class="form-control" type="text" name="last_name" id="last_name"
                      value="{{ old('last_name', $user->last_name) }}" required>
                    @if($errors->has('last_name'))
                    <div class="invalid-feedback">
                      {{ $errors->first('last_name') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.last_name_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label class="required" for="email">{{ trans('cruds.user.fields.email') }}</label>
                    <input class="form-control" type="email" name="email" id="email" value="{{ old('email', $user->email) }}"
                      required>
                    @if($errors->has('email'))
                    <div class="invalid-feedback">
                      {{ $errors->first('email') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.email_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label>{{ trans('cruds.user.fields.gender') }}</label>
                    @foreach(App\Models\User::GENDER_RADIO as $key => $label)
                    <div>
                      <input type="radio" id="gender_{{ $key }}" name="gender" value="{{ $key }}" {{ old('gender',
                        $user->gender) === (string) $key ? 'checked' : '' }}>
                      <label for="gender_{{ $key }}">{{ $label }}</label>
                    </div>
                    @endforeach
                    @if($errors->has('gender'))
                    <div class="invalid-feedback">
                      {{ $errors->first('gender') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.gender_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="dob">{{ trans('cruds.user.fields.dob') }}</label>
                    <input class="form-control date" type="date" name="dob" id="dob" value="{{ old('dob', $user->dob) }}">
                    @if($errors->has('dob'))
                    <div class="invalid-feedback">
                      {{ $errors->first('dob') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.dob_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="mobile_no">{{ trans('cruds.user.fields.mobile_no') }}</label>
                    <input class="form-control" type="text" name="mobile_no" id="mobile_no"
                      value="{{ old('mobile_no', $user->mobile_no) }}">
                    @if($errors->has('mobile_no'))
                    <div class="invalid-feedback">
                      {{ $errors->first('mobile_no') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.mobile_no_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="address_line_1">{{ trans('cruds.user.fields.address_line_1') }}</label>
                    <input class="form-control" type="text" name="address_line_1" id="address_line_1"
                      value="{{ old('address_line_1', $user->address_line_1) }}">
                    @if($errors->has('address_line_1'))
                    <div class="invalid-feedback">
                      {{ $errors->first('address_line_1') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.address_line_1_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="address_line_2">{{ trans('cruds.user.fields.address_line_2') }}</label>
                    <input class="form-control" type="text" name="address_line_2" id="address_line_2"
                      value="{{ old('address_line_2', $user->address_line_2) }}">
                    @if($errors->has('address_line_2'))
                    <div class="invalid-feedback">
                      {{ $errors->first('address_line_2') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.address_line_2_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="city">{{ trans('cruds.user.fields.city') }}</label>
                    <input class="form-control" type="text" name="city" id="city" value="{{ old('city', $user->city) }}">
                    @if($errors->has('city'))
                    <div class="invalid-feedback">
                      {{ $errors->first('city') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.city_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="state">{{ trans('cruds.user.fields.state') }}</label>
                    <input class="form-control" type="text" name="state" id="state" value="{{ old('state', $user->state) }}">
                    @if($errors->has('state'))
                    <div class="invalid-feedback">
                      {{ $errors->first('state') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.state_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="coutry">{{ trans('cruds.user.fields.coutry') }}</label>
                    <input class="form-control" type="text" name="coutry" id="coutry"
                      value="{{ old('coutry', $user->coutry) }}">
                    @if($errors->has('coutry'))
                    <div class="invalid-feedback">
                      {{ $errors->first('coutry') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.coutry_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="pincode">{{ trans('cruds.user.fields.pincode') }}</label>
                    <input class="form-control" type="text" name="pincode" id="pincode"
                      value="{{ old('pincode', $user->pincode) }}">
                    @if($errors->has('pincode'))
                    <div class="invalid-feedback">
                      {{ $errors->first('pincode') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.pincode_helper') }}</span>
                  </div>
                  <div class="form-group">
                    <label for="profile_photo">{{ trans('cruds.user.fields.profile_photo') }}</label>
                    <div class="needsclick dropzone" id="profile_photo-dropzone">
                    </div>
                    @if($errors->has('profile_photo'))
                    <div class="invalid-feedback">
                      {{ $errors->first('profile_photo') }}
                    </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.user.fields.profile_photo_helper') }}</span>
                  </div>
                  <div class="form-group">
                          <div class="alert alert-success d-none" id="success-message" role="alert"></div>
                            <a class="btn btn-secondary" href="{{ url('/home') }}">
                                {{ trans('global.back_to_list') }}
                            </a>
                         
                    <button class="btn btn-danger" type="submit">
                      {{ trans('global.save') }}
                    </button>
                  </div>
                </form>
              </div>
            </div>
      
          </div>
        </div>
      </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.perfect-scrollbar/1.5.0/perfect-scrollbar.min.js"></script>
    <script src="https://unpkg.com/@coreui/coreui@3.2/dist/js/coreui.min.js"></script>
    <script src="//cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.2.4/js/dataTables.buttons.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.2.4/js/buttons.flash.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.4/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.4/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.4/js/buttons.colVis.min.js"></script>
    <script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js"></script>
    <script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.3.0/js/dataTables.select.min.js"></script>
    <script src="https://cdn.ckeditor.com/ckeditor5/16.0.0/classic/ckeditor.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.22.2/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/js/select2.full.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.1/min/dropzone.min.js"></script>
    <script src="{{ asset('js/main.js') }}"></script>
    <script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('course_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('frontend.courses.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-Course:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
    <script>
        $(function() {
  let copyButtonTrans = '{{ trans('global.datatables.copy') }}'
  let csvButtonTrans = '{{ trans('global.datatables.csv') }}'
  let excelButtonTrans = '{{ trans('global.datatables.excel') }}'
  let pdfButtonTrans = '{{ trans('global.datatables.pdf') }}'
  let printButtonTrans = '{{ trans('global.datatables.print') }}'
  let colvisButtonTrans = '{{ trans('global.datatables.colvis') }}'
  let selectAllButtonTrans = '{{ trans('global.select_all') }}'
  let selectNoneButtonTrans = '{{ trans('global.deselect_all') }}'

  let languages = {
    'en': 'https://cdn.datatables.net/plug-ins/1.10.19/i18n/English.json'
  };

  $.extend(true, $.fn.dataTable.Buttons.defaults.dom.button, { className: 'btn' })
  $.extend(true, $.fn.dataTable.defaults, {
    language: {
      url: languages['{{ app()->getLocale() }}']
    },
    columnDefs: [{
        orderable: false,
        className: 'select-checkbox',
        targets: 0
    }, {
        orderable: false,
        searchable: false,
        targets: -1
    }],
    select: {
      style:    'multi+shift',
      selector: 'td:first-child'
    },
    order: [],
    scrollX: true,
    pageLength: 100,
    dom: 'lBfrtip<"actions">',
    buttons: [
      {
        extend: 'selectAll',
        className: 'btn-primary',
        text: selectAllButtonTrans,
        exportOptions: {
          columns: ':visible'
        },
        action: function(e, dt) {
          e.preventDefault()
          dt.rows().deselect();
          dt.rows({ search: 'applied' }).select();
        }
      },
      {
        extend: 'selectNone',
        className: 'btn-primary',
        text: selectNoneButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      },
      {
        extend: 'copy',
        className: 'btn-default',
        text: copyButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      },
      {
        extend: 'csv',
        className: 'btn-default',
        text: csvButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      },
      {
        extend: 'excel',
        className: 'btn-default',
        text: excelButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      },
      {
        extend: 'pdf',
        className: 'btn-default',
        text: pdfButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      },
      {
        extend: 'print',
        className: 'btn-default',
        text: printButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      },
      {
        extend: 'colvis',
        className: 'btn-default',
        text: colvisButtonTrans,
        exportOptions: {
          columns: ':visible'
        }
      }
    ]
  });

  $.fn.dataTable.ext.classes.sPageButton = '';
});

    </script>
    @yield('scripts')
</body>

</html>