@extends('layouts.frontend')
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card">
                <div class="card-header">
                    {{ trans('global.create') }} {{ trans('cruds.location.title_singular') }}
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route("frontend.locations.store") }}" enctype="multipart/form-data">
                        @method('POST')
                        @csrf
                        <div class="form-group">
                            <label class="required" for="title">{{ trans('cruds.location.fields.title') }}</label>
                            <input class="form-control" type="text" name="title" id="title" value="{{ old('title', '') }}" required>
                            @if($errors->has('title'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('title') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.title_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="address_line_1">{{ trans('cruds.location.fields.address_line_1') }}</label>
                            <input class="form-control" type="text" name="address_line_1" id="address_line_1" value="{{ old('address_line_1', '') }}">
                            @if($errors->has('address_line_1'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('address_line_1') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.address_line_1_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="address_line_2">{{ trans('cruds.location.fields.address_line_2') }}</label>
                            <input class="form-control" type="text" name="address_line_2" id="address_line_2" value="{{ old('address_line_2', '') }}">
                            @if($errors->has('address_line_2'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('address_line_2') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.address_line_2_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="landmark">{{ trans('cruds.location.fields.landmark') }}</label>
                            <input class="form-control" type="text" name="landmark" id="landmark" value="{{ old('landmark', '') }}">
                            @if($errors->has('landmark'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('landmark') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.landmark_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="city">{{ trans('cruds.location.fields.city') }}</label>
                            <input class="form-control" type="text" name="city" id="city" value="{{ old('city', '') }}">
                            @if($errors->has('city'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('city') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.city_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="state">{{ trans('cruds.location.fields.state') }}</label>
                            <input class="form-control" type="text" name="state" id="state" value="{{ old('state', '') }}">
                            @if($errors->has('state'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('state') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.state_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="country">{{ trans('cruds.location.fields.country') }}</label>
                            <input class="form-control" type="text" name="country" id="country" value="{{ old('country', '') }}">
                            @if($errors->has('country'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('country') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.country_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="zip">{{ trans('cruds.location.fields.zip') }}</label>
                            <input class="form-control" type="text" name="zip" id="zip" value="{{ old('zip', '') }}">
                            @if($errors->has('zip'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('zip') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.zip_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label>{{ trans('cruds.location.fields.is_active') }}</label>
                            <select class="form-control" name="is_active" id="is_active">
                                <option value disabled {{ old('is_active', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                                @foreach(App\Models\Location::IS_ACTIVE_SELECT as $key => $label)
                                    <option value="{{ $key }}" {{ old('is_active', 'Yes') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                            @if($errors->has('is_active'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('is_active') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.is_active_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label>{{ trans('cruds.location.fields.is_primary') }}</label>
                            <select class="form-control" name="is_primary" id="is_primary">
                                <option value disabled {{ old('is_primary', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                                @foreach(App\Models\Location::IS_PRIMARY_SELECT as $key => $label)
                                    <option value="{{ $key }}" {{ old('is_primary', 'No') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                            @if($errors->has('is_primary'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('is_primary') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.location.fields.is_primary_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-danger" type="submit">
                                {{ trans('global.save') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection