@extends('layouts.frontend')
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card">
                <div class="card-header">
                    {{ trans('global.show') }} {{ trans('cruds.course.title') }}
                </div>

                <div class="card-body">
                    <div class="form-group">
                        <div class="form-group">
                            <a class="btn btn-default" href="{{ route('frontend.courses.index') }}">
                                {{ trans('global.back_to_list') }}
                            </a>
                        </div>
                        <table class="table table-bordered table-striped">
                            <tbody>
                              @if(!$isStudent)
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.id') }}
                                    </th>
                                    <td>
                                        {{ $course->id }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.teacher') }}
                                    </th>
                                    <td>
                                        {{ $course->teacher->name ?? '' }}
                                    </td>
                                </tr>
                              @endif
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.title') }}
                                    </th>
                                    <td>
                                        {{ $course->title }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.description') }}
                                    </th>
                                    <td>
                                        {{ $course->description }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.price') }}
                                    </th>
                                    <td>
                                        {{ $course->price }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.thumbnail') }}
                                    </th>
                                    <td>
                                        @foreach($course->thumbnail as $key => $media)
                                            <a href="{{ $media->getUrl() }}" target="_blank" style="display: inline-block">
                                                <img src="{{ $media->getUrl('thumb') }}">
                                            </a>
                                        @endforeach
                                    </td>
                                </tr>
                              @if(!$isStudent)
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.is_published') }}
                                    </th>
                                    <td>
                                        <input type="checkbox" disabled="disabled" {{ $course->is_published ? 'checked' : '' }}>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.students') }}
                                    </th>
                                    <td>
                                        @foreach($course->students as $key => $students)
                                            <span class="label label-info">{{ $students->name }}</span>
                                        @endforeach
                                    </td>
                                </tr>
                              @endif
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.level') }}
                                    </th>
                                    <td>
                                        {{ $course->level }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.accreditation_status') }}
                                    </th>
                                    <td>
                                        {{ App\Models\Course::ACCREDITATION_STATUS_SELECT[$course->accreditation_status] ?? '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.credit_equivalency') }}
                                    </th>
                                    <td>
                                        {{ $course->credit_equivalency }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.qualification_number') }}
                                    </th>
                                    <td>
                                        {{ $course->qualification_number }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.progression_routes') }}
                                    </th>
                                    <td>
                                        {{ $course->progression_routes }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.course.fields.availability') }}
                                    </th>
                                    <td>
                                        {{ $course->availability }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="form-group">
                          <div class="alert alert-success d-none" id="success-message" role="alert"></div>
                            <a class="btn btn-secondary" href="{{ route('frontend.courses.index') }}">
                                {{ trans('global.back_to_list') }}
                            </a>
                          @if($isStudent && !$isCourseEnroll)
                          <input type="submit" class="btn btn-xs btn-primary" id="enroll-course" value="{{ trans('global.enroll') }}">
                                <input type="hidden" id="course-id" value="<?php echo $course->id; ?>">
                          @endif
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $("#enroll-course").click(function(){
            var courseId = $("#course-id").val();
            $.ajax({
            url: '{{ route('frontend.courses.enroll') }}',
            method: 'GET',
            data: { courseId: courseId },
            success: function (response) {
              if(response.message){
                var flashMessage = $("#success-message").text(response.message);
              $( "#success-message" ).removeClass( "d-none" );
              setTimeout(function() {
                  $( "#success-message" ).addClass( "d-none" );
                  $("#success-message").text('');
                  $("#enroll-course").addClass('d-none');
              }, 5000);
              }
              },
            error: function (xhr, status, error) {
                console.error(error);
                // Handle errors here
            }
            });
        });
    });
</script>
@endsection