@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.teach.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.teaches.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.teach.fields.id') }}
                        </th>
                        <td>
                            {{ $teach->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.teach.fields.first_name') }}
                        </th>
                        <td>
                            {{ $teach->first_name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.teach.fields.last_name') }}
                        </th>
                        <td>
                            {{ $teach->last_name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.teach.fields.qualification') }}
                        </th>
                        <td>
                            {{ $teach->qualification }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.teach.fields.description') }}
                        </th>
                        <td>
                            {!! $teach->description !!}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.teaches.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection