@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.course.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.courses.update", [$course->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="teacher_id">{{ trans('cruds.course.fields.teacher') }}</label>
                <select class="form-control select2 {{ $errors->has('teacher') ? 'is-invalid' : '' }}" name="teacher_id" id="teacher_id" required>
                    @foreach($teachers as $id => $entry)
                        <option value="{{ $id }}" {{ (old('teacher_id') ? old('teacher_id') : $course->teacher->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('teacher'))
                    <div class="invalid-feedback">
                        {{ $errors->first('teacher') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.teacher_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="title">{{ trans('cruds.course.fields.title') }}</label>
                <input class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" type="text" name="title" id="title" value="{{ old('title', $course->title) }}" required>
                @if($errors->has('title'))
                    <div class="invalid-feedback">
                        {{ $errors->first('title') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.title_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="description">{{ trans('cruds.course.fields.description') }}</label>
                <textarea class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" name="description" id="description" required>{{ old('description', $course->description) }}</textarea>
                @if($errors->has('description'))
                    <div class="invalid-feedback">
                        {{ $errors->first('description') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.description_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="price">{{ trans('cruds.course.fields.price') }}</label>
                <input class="form-control {{ $errors->has('price') ? 'is-invalid' : '' }}" type="number" name="price" id="price" value="{{ old('price', $course->price) }}" step="0.01">
                @if($errors->has('price'))
                    <div class="invalid-feedback">
                        {{ $errors->first('price') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.price_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="thumbnail">{{ trans('cruds.course.fields.thumbnail') }}</label>
                <div class="needsclick dropzone {{ $errors->has('thumbnail') ? 'is-invalid' : '' }}" id="thumbnail-dropzone">
                </div>
                @if($errors->has('thumbnail'))
                    <div class="invalid-feedback">
                        {{ $errors->first('thumbnail') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.thumbnail_helper') }}</span>
            </div>
            <div class="form-group">
                <div class="form-check {{ $errors->has('is_published') ? 'is-invalid' : '' }}">
                    <input type="hidden" name="is_published" value="0">
                    <input class="form-check-input" type="checkbox" name="is_published" id="is_published" value="1" {{ $course->is_published || old('is_published', 0) === 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="is_published">{{ trans('cruds.course.fields.is_published') }}</label>
                </div>
                @if($errors->has('is_published'))
                    <div class="invalid-feedback">
                        {{ $errors->first('is_published') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.is_published_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="students">{{ trans('cruds.course.fields.students') }}</label>
                <div style="padding-bottom: 4px">
                    <span class="btn btn-info btn-xs select-all" style="border-radius: 0">{{ trans('global.select_all') }}</span>
                    <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0">{{ trans('global.deselect_all') }}</span>
                </div>
                <select class="form-control select2 {{ $errors->has('students') ? 'is-invalid' : '' }}" name="students[]" id="students" multiple>
                    @foreach($students as $id => $student)
                        <option value="{{ $id }}" {{ (in_array($id, old('students', [])) || $course->students->contains($id)) ? 'selected' : '' }}>{{ $student }}</option>
                    @endforeach
                </select>
                @if($errors->has('students'))
                    <div class="invalid-feedback">
                        {{ $errors->first('students') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.students_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="level">{{ trans('cruds.course.fields.level') }}</label>
                <input class="form-control {{ $errors->has('level') ? 'is-invalid' : '' }}" type="text" name="level" id="level" value="{{ old('level', $course->level) }}">
                @if($errors->has('level'))
                    <div class="invalid-feedback">
                        {{ $errors->first('level') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.level_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.course.fields.accreditation_status') }}</label>
                <select class="form-control {{ $errors->has('accreditation_status') ? 'is-invalid' : '' }}" name="accreditation_status" id="accreditation_status">
                    <option value disabled {{ old('accreditation_status', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\Course::ACCREDITATION_STATUS_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('accreditation_status', $course->accreditation_status) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('accreditation_status'))
                    <div class="invalid-feedback">
                        {{ $errors->first('accreditation_status') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.accreditation_status_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="credit_equivalency">{{ trans('cruds.course.fields.credit_equivalency') }}</label>
                <input class="form-control {{ $errors->has('credit_equivalency') ? 'is-invalid' : '' }}" type="text" name="credit_equivalency" id="credit_equivalency" value="{{ old('credit_equivalency', $course->credit_equivalency) }}">
                @if($errors->has('credit_equivalency'))
                    <div class="invalid-feedback">
                        {{ $errors->first('credit_equivalency') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.credit_equivalency_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="qualification_number">{{ trans('cruds.course.fields.qualification_number') }}</label>
                <input class="form-control {{ $errors->has('qualification_number') ? 'is-invalid' : '' }}" type="text" name="qualification_number" id="qualification_number" value="{{ old('qualification_number', $course->qualification_number) }}">
                @if($errors->has('qualification_number'))
                    <div class="invalid-feedback">
                        {{ $errors->first('qualification_number') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.qualification_number_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="progression_routes">{{ trans('cruds.course.fields.progression_routes') }}</label>
                <input class="form-control {{ $errors->has('progression_routes') ? 'is-invalid' : '' }}" type="text" name="progression_routes" id="progression_routes" value="{{ old('progression_routes', $course->progression_routes) }}">
                @if($errors->has('progression_routes'))
                    <div class="invalid-feedback">
                        {{ $errors->first('progression_routes') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.progression_routes_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="availability">{{ trans('cruds.course.fields.availability') }}</label>
                <input class="form-control {{ $errors->has('availability') ? 'is-invalid' : '' }}" type="text" name="availability" id="availability" value="{{ old('availability', $course->availability) }}">
                @if($errors->has('availability'))
                    <div class="invalid-feedback">
                        {{ $errors->first('availability') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.course.fields.availability_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection

@section('scripts')
<script>
    var uploadedThumbnailMap = {}
Dropzone.options.thumbnailDropzone = {
    url: '{{ route('admin.courses.storeMedia') }}',
    maxFilesize: 2, // MB
    acceptedFiles: '.jpeg,.jpg,.png,.gif',
    addRemoveLinks: true,
    headers: {
      'X-CSRF-TOKEN': "{{ csrf_token() }}"
    },
    params: {
      size: 2,
      width: 4096,
      height: 4096
    },
    success: function (file, response) {
      $('form').append('<input type="hidden" name="thumbnail[]" value="' + response.name + '">')
      uploadedThumbnailMap[file.name] = response.name
    },
    removedfile: function (file) {
      console.log(file)
      file.previewElement.remove()
      var name = ''
      if (typeof file.file_name !== 'undefined') {
        name = file.file_name
      } else {
        name = uploadedThumbnailMap[file.name]
      }
      $('form').find('input[name="thumbnail[]"][value="' + name + '"]').remove()
    },
    init: function () {
@if(isset($course) && $course->thumbnail)
      var files = {!! json_encode($course->thumbnail) !!}
          for (var i in files) {
          var file = files[i]
          this.options.addedfile.call(this, file)
          this.options.thumbnail.call(this, file, file.preview ?? file.preview_url)
          file.previewElement.classList.add('dz-complete')
          $('form').append('<input type="hidden" name="thumbnail[]" value="' + file.file_name + '">')
        }
@endif
    },
     error: function (file, response) {
         if ($.type(response) === 'string') {
             var message = response //dropzone sends it's own error messages in string
         } else {
             var message = response.errors.file
         }
         file.previewElement.classList.add('dz-error')
         _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
         _results = []
         for (_i = 0, _len = _ref.length; _i < _len; _i++) {
             node = _ref[_i]
             _results.push(node.textContent = message)
         }

         return _results
     }
}

</script>
@endsection