<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesTable extends Migration
{
    public function up()
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title')->nullable();
            $table->longText('description')->nullable();
            $table->decimal('price', 15, 2)->nullable();
            $table->boolean('is_published')->default(0)->nullable();
            $table->string('level')->nullable();
            $table->string('accreditation_status')->nullable();
            $table->string('credit_equivalency')->nullable();
            $table->string('qualification_number')->nullable();
            $table->string('progression_routes')->nullable();
            $table->string('availability')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
