<?php

namespace App\Http\Requests;

use App\Models\Teach;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateTeachRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('teach_edit');
    }

    public function rules()
    {
        return [
            'first_name' => [
                'string',
                'required',
            ],
            'last_name' => [
                'string',
                'required',
            ],
            'qualification' => [
                'string',
                'nullable',
            ],
        ];
    }
}
