<?php

namespace App\Http\Requests;

use App\Models\Payment;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StorePaymentRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('payments');
    }

    public function rules()
    {
        return [
            'user_id' => [
                'required',
                'integer',
            ],
            'mode' => [
                'string',
                'required',
            ],
            'amount' => [
                'double',
                'required',
            ],
            'thumbnail' => [
                'array',
            ],
        ];
    }
}
