<?php

namespace App\Http\Requests;

use App\Models\Course;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreCourseRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('course_create');
    }

    public function rules()
    {
        return [
            'teacher_id' => [
                'required',
                'integer',
            ],
            'title' => [
                'string',
                'required',
            ],
            'description' => [
                'required',
            ],
            'thumbnail' => [
                'array',
            ],
            'students.*' => [
                'integer',
            ],
            'students' => [
                'array',
            ],
            'level' => [
                'string',
                'nullable',
            ],
            'credit_equivalency' => [
                'string',
                'nullable',
            ],
            'qualification_number' => [
                'string',
                'nullable',
            ],
            'progression_routes' => [
                'string',
                'nullable',
            ],
            'availability' => [
                'string',
                'nullable',
            ],
        ];
    }
}
