<?php

namespace App\Http\Requests;

use App\Models\Certificate;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreCertificateRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('course_create');
    }

    public function rules()
    {
        return [
            'student_id' => [
                'required',
                'integer',
            ],             
            'cerDesign' => [
                'string',
            ],
            'refNo' => [
                'string',
            ], 
            'emailTemplate' => [
                'string',
            ], 
            'courseStartDate' => [
                'string',
            ], 
            'courseEndDate' => [
                'string',
            ], 
            'emailContent' => [
                'string',
            ],
            'createdAt' => [
                'nullable',
                'date',
            ],
        ];
        
    }
}
