<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\MediaUploadingTrait;
use App\Http\Requests\MassDestroyTeachRequest;
use App\Http\Requests\StoreTeachRequest;
use App\Http\Requests\UpdateTeachRequest;
use App\Models\Teach;
use Gate;
use Illuminate\Http\Request;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Symfony\Component\HttpFoundation\Response;

class TeachesController extends Controller
{
    use MediaUploadingTrait;

    public function index()
    {
        abort_if(Gate::denies('teach_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $teaches = Teach::all();

        return view('frontend.teaches.index', compact('teaches'));
    }

    public function create()
    {
        abort_if(Gate::denies('teach_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('frontend.teaches.create');
    }

    public function store(StoreTeachRequest $request)
    {
        $teach = Teach::create($request->all());

        if ($media = $request->input('ck-media', false)) {
            Media::whereIn('id', $media)->update(['model_id' => $teach->id]);
        }

        return redirect()->route('frontend.teaches.index');
    }

    public function edit(Teach $teach)
    {
        abort_if(Gate::denies('teach_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('frontend.teaches.edit', compact('teach'));
    }

    public function update(UpdateTeachRequest $request, Teach $teach)
    {
        $teach->update($request->all());

        return redirect()->route('frontend.teaches.index');
    }

    public function show(Teach $teach)
    {
        abort_if(Gate::denies('teach_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('frontend.teaches.show', compact('teach'));
    }

    public function destroy(Teach $teach)
    {
        abort_if(Gate::denies('teach_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $teach->delete();

        return back();
    }

    public function massDestroy(MassDestroyTeachRequest $request)
    {
        $teaches = Teach::find(request('ids'));

        foreach ($teaches as $teach) {
            $teach->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }

    public function storeCKEditorImages(Request $request)
    {
        abort_if(Gate::denies('teach_create') && Gate::denies('teach_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $model         = new Teach();
        $model->id     = $request->input('crud_id', 0);
        $model->exists = true;
        $media         = $model->addMediaFromRequest('upload')->toMediaCollection('ck-media');

        return response()->json(['id' => $media->id, 'url' => $media->getUrl()], Response::HTTP_CREATED);
    }
}
