<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdatePasswordRequest;
use App\Http\Requests\UpdateProfileRequest;
use App\Models\User;
use Hash;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ProfileController extends Controller
{
    public function index()
    {
        return view('frontend.profile');
    }

    public function update(UpdateProfileRequest $request)
    {
        $user = auth()->user();

        $user->update($request->validated());

        return redirect()->route('frontend.profile.index')->with('message', __('global.update_profile_success'));
    }

    public function destroy()
    {
        $user = auth()->user();

        $user->update([
            'email' => time() . '_' . $user->email,
        ]);

        $user->delete();

        return redirect()->route('login')->with('message', __('global.delete_account_success'));
    }

    public function password(UpdatePasswordRequest $request)
    {
        auth()->user()->update($request->validated());

        return redirect()->route('frontend.profile.index')->with('message', __('global.change_password_success'));
    }
  public function updateprofile()
    {
        $roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
        $user = User::where('id', $roleId)->first();

        return view('frontend.users.updateprofile', compact('user'));
    }
   public function edit(Request $request)
    {
     $roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
      $user = User::find($roleId);
    $user->update($request->all());
      return redirect()->route('frontend.profile.updateprofile')
      ->with('success', 'Post updated successfully.');
   }
  public function updatepassword()
    {
        /*$roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
        $user = User::where('id', $roleId)->first();*/

        return view('frontend.users.updatepassword');
    }
   public function updatepwd(Request $request)
    {
     $roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
      $user = User::find($roleId);
     $data = $request->only('password');
     $temp = Hash::make($data['password']);
     
    $user->update(array('password' => $temp));
      return redirect()->route('frontend.profile.updatepassword')
      ->with('success', 'password updated successfully.');
   }
}
