<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\MediaUploadingTrait;
use App\Http\Requests\MassDestroyCourseRequest;
use App\Http\Requests\StoreCourseRequest;
use App\Http\Requests\UpdateCourseRequest;
use App\Models\Course;
use App\Models\User;
use App\Models\RoleUser;
use App\Models\StudentCourseEnroll;
use Gate;
use Illuminate\Http\Request;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class CoursesController extends Controller
{
    use MediaUploadingTrait;

    public function index()
    {
        abort_if(Gate::denies('course_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $courses = Course::with(['teacher', 'students', 'media'])->get();
      $roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
        $roleUser = RoleUser::withTrashed()->where('user_id', $roleId)->first();
	$isStudent = $roleUser['role_id'] == 3 ? true : false;
        return view('frontend.courses.index', compact('courses','isStudent'));
    }

    public function create()
    {
        abort_if(Gate::denies('course_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $teachers = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $students = User::pluck('name', 'id');

        return view('frontend.courses.create', compact('students', 'teachers'));
    }

    public function store(StoreCourseRequest $request)
    {
        $course = Course::create($request->all());
        $course->students()->sync($request->input('students', []));
        foreach ($request->input('thumbnail', []) as $file) {
            $course->addMedia(storage_path('tmp/uploads/' . basename($file)))->toMediaCollection('thumbnail');
        }

        if ($media = $request->input('ck-media', false)) {
            Media::whereIn('id', $media)->update(['model_id' => $course->id]);
        }

        return redirect()->route('frontend.courses.index');
    }

    public function edit(Course $course)
    {
        abort_if(Gate::denies('course_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $teachers = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $students = User::pluck('name', 'id');

        $course->load('teacher', 'students');

        return view('frontend.courses.edit', compact('course', 'students', 'teachers'));
    }

    public function update(UpdateCourseRequest $request, Course $course)
    {
        $course->update($request->all());
        $course->students()->sync($request->input('students', []));
        if (count($course->thumbnail) > 0) {
            foreach ($course->thumbnail as $media) {
                if (! in_array($media->file_name, $request->input('thumbnail', []))) {
                    $media->delete();
                }
            }
        }
        $media = $course->thumbnail->pluck('file_name')->toArray();
        foreach ($request->input('thumbnail', []) as $file) {
            if (count($media) === 0 || ! in_array($file, $media)) {
                $course->addMedia(storage_path('tmp/uploads/' . basename($file)))->toMediaCollection('thumbnail');
            }
        }

        return redirect()->route('frontend.courses.index');
    }

    public function show(Course $course)
    {
        abort_if(Gate::denies('course_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $course->load('teacher', 'students');
		
        $roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
        $roleUser = RoleUser::withTrashed()->where('user_id', $roleId)->first();
        $isStudent = $roleUser['role_id'] == 3 ? true : false;
      	$courseEnroll = StudentCourseEnroll::where('student_id', $roleId)->first();
      	$isCourseEnroll = $courseEnroll ? true : false;
        return view('frontend.courses.show', compact('course', 'isStudent', 'isCourseEnroll'));
    }

    public function destroy(Course $course)
    {
        abort_if(Gate::denies('course_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $course->delete();

        return back();
    }

    public function massDestroy(MassDestroyCourseRequest $request)
    {
        $courses = Course::find(request('ids'));

        foreach ($courses as $course) {
            $course->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }

    public function storeCKEditorImages(Request $request)
    {
        abort_if(Gate::denies('course_create') && Gate::denies('course_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $model         = new Course();
        $model->id     = $request->input('crud_id', 0);
        $model->exists = true;
        $media         = $model->addMediaFromRequest('upload')->toMediaCollection('ck-media');

        return response()->json(['id' => $media->id, 'url' => $media->getUrl()], Response::HTTP_CREATED);
    }
  public function enroll(Request $request)
    {
        $data = $request->all();
        $insertedRecord = StudentCourseEnroll::create([
        'student_id' => session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d'),
        'course_id' => $data['courseId'],
        ]);
    	if($insertedRecord->id){
          return response()->json(['message' => 'Congratulations you enroll to this course']);
        }
    	return response()->json(['message' => 'Sorry.. Please try again']);
    }
  
  public function mycourse() {
        $roleId = session('login_web_59ba36addc2b2f9401580f014c7f58ea4e30989d');
        $studentCourse = StudentCourseEnroll::where('student_id', '=', $roleId)->first();
        // $course = Course::find($studentCourse['course_id']);
        // return view('frontend.courses.mycourse', compact('course'));
        $courses = Course::all(); // Replace with your actual logic to fetch courses
        return view('admin.courses.index', compact('courses'));
    }


 
}
