<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\Certirecord;
class DegreeController extends Controller
{
    public function index()
    {
        
        $degreeData = [
            'degreeName' => 'Bachelor of Science',
            'degreeLevel' => 'Undergraduate',
        ];
        return view('degree', compact('degreeData'));
    }

    public function downloadDegree(Request $request)
    {
         
        // $referenceNumber = '126'; 
        $referenceNumber = $request->referenceNumber;
        $rs = Certirecord::where('refNo', $referenceNumber)->first();
        if ($rs) {
            $certificate = (object)$rs->getOriginal();
        } else{
                return redirect()->back()->with('error', 'The reference number does not match.');
        }
        if ($referenceNumber == $certificate->refNo) {
            //die("ASDFA122");
            $data = ['title' => 'Sample PDF'];  
            $title = "asfas";
            $date = date('d/m/Y');
            $background = public_path('corporate.jpg');  // Corrected line
            //return view('degreePdf', compact('title','data','background','certificate'));

            $pdf = PDF::loadView('degreePdf', compact('data', 'title','background','certificate','date'));  // Passing background to the view
           return $pdf->download('degreePdf.pdf');
    
        } else {
            return redirect()->back()->with('error', 'The reference number does not match.');
        }
    }

    public function generatePDF11()
    {
        $data = ['title' => 'Sample PDF'];
        $pdf = PDF::loadView('degreePdf', $data);
        return $pdf->download('degreePdf.pdf');
    }

  
}