<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\MediaUploadingTrait;
use App\Http\Requests\StoreTeachRequest;
use App\Http\Requests\UpdateTeachRequest;
use App\Http\Resources\Admin\TeachResource;
use App\Models\Teach;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TeachesApiController extends Controller
{
    use MediaUploadingTrait;

    public function index()
    {
        abort_if(Gate::denies('teach_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new TeachResource(Teach::all());
    }

    public function store(StoreTeachRequest $request)
    {
        $teach = Teach::create($request->all());

        return (new TeachResource($teach))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Teach $teach)
    {
        abort_if(Gate::denies('teach_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new TeachResource($teach);
    }

    public function update(UpdateTeachRequest $request, Teach $teach)
    {
        $teach->update($request->all());

        return (new TeachResource($teach))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Teach $teach)
    {
        abort_if(Gate::denies('teach_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $teach->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
