<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\MediaUploadingTrait;
use App\Http\Requests\MassDestroyCourseRequest;
use App\Http\Requests\StoreCertificateRequest;
use App\Http\Requests\UpdateCertificateRequest;
use App\Models\Certificate;
use App\Models\Certirecord;
use App\Models\Course;
use App\Models\RoleUser;
use App\Models\User;
use File;
use Gate;
use Illuminate\Http\Request;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestMail;
use App\Models\StudentCourseEnroll;
use Illuminate\Support\Facades\DB;
class CertificatesController extends Controller
{
    use MediaUploadingTrait;

    // public function sendTestEmail($data)
    // {
    //     try {
    //         print_r($data); 
    //         $mailContent = (object) ['StudentName' => $data->stuName, 'RefNo' => $data->refNo,'CourseName'=>'ABC','courseStartDate'=>$data->courseStartDate,'courseEndDate'=>$data->courseEndDate];
    //         Mail::to($data->stuEmail)->send(new TestMail($mailContent));
    //         die("ASdfas");
    //         return "Email sent successfully!";
    //         } catch (\Exception $e) {
    //             return "Error sending email: " . $e->getMessage();
    //         }
    // }

    public function index()
    {
       
        abort_if(Gate::denies('course_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $certificates = Certificate::with(['student', 'media'])->get();
        $allSessionValues = session()->all();
        // print_r($allSessionValues);die();
        return view('admin.certificates.index', compact('certificates'));
    }

    public function create()
    {
      abort_if(Gate::denies('course_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
      $studentList = RoleUser ::withTrashed()->select('user_id')->where('role_id', 3)->get();
      $studentList = $studentList->toArray();
      $ids = array_column($studentList, 'user_id');
      $studentAll = User::whereIn('id', $ids)->get();

        $teachers = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $students = User::pluck('name', 'id');

        return view('admin.certificates.create', compact('students', 'teachers', 'studentAll'));
    }


    public function newPage()
    {
        die("newPage");
        abort_if(Gate::denies('course_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
      	$studentList = RoleUser ::withTrashed()->select('user_id')->where('role_id', 3)->get();
      $studentList = $studentList->toArray();
      $ids = array_column($studentList, 'user_id');
      $studentAll = User::whereIn('id', $ids)->get();
        $teachers = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $students = User::pluck('name', 'id');

        return view('admin.certificates.create', compact('students', 'teachers', 'studentAll'));
    }

    public function store(StoreCertificateRequest $request)
    {
        $data = $request->validated();
       
        $students = User::where('id', $data['student_id'])->first();
        $stu=(object)$students->toArray();
        $stuName=$stu->name.' '.$stu->last_name;

        // SELECT users.id, users.name, users.email, role_user.role_id, student_course_enroll.course_id,courses.title
        // FROM users
        // JOIN role_user ON users.id = role_user.user_id
        // JOIN student_course_enroll ON users.id = student_course_enroll.student_id
        // join courses ON courses.id = student_course_enroll.course_id
        // WHERE users.id = 5;

       // print_r($data);

        $Find_refNo = DB::select('SELECT * FROM certirecord WHERE refNo = :refNo', ['refNo' => $data['refNo']]);
        if ($Find_refNo) {
            die($data['refNo'] . ' - Provided Reference Number is already in use');
        }

        $result = DB::select('SELECT users.id, users.name, users.email, role_user.role_id, student_course_enroll.course_id, courses.title
        FROM users
        JOIN role_user ON users.id = role_user.user_id
        JOIN student_course_enroll ON users.id = student_course_enroll.student_id
        JOIN courses ON courses.id = student_course_enroll.course_id
        WHERE users.id = :user_id', ['user_id' => $data['student_id']]);

        if (empty($result)) {
            die($data['student_id']."-Student not merged with any course");
        }

        $certificate = Certirecord::create([
            'stuId' => $data['student_id'],
            'stuName' => $stuName,
            'stuEmail' => $stu->email,
            'courseName' => $result[0]->title,
            'refNo' => $data['refNo'],
            'cerDesign' => $data['cerDesign'],
            'emailTemplate' => $data['emailTemplate'],
            'emailContent' => "w",//$data['emailContent'],
            'courseStartDate'=> $data['courseStartDate'],
            'courseEndDate'=> $data['courseEndDate'],
            'createdAt' => now()
        ]);
        // $certificate = Certificate::create($request->all());
            $originalArray = $certificate->getOriginal();
            // print_r($originalArray);
            // die("Sdfa");
            $keysToExtract = [
                'stuId',
                'stuName',
                'stuEmail',
                'courseName',   
                'refNo',
                'cerDesign',
                'emailTemplate',
                'emailContent',
                'courseStartDate',
                'courseEndDate',
            ];
            $rs = (object) array_intersect_key($originalArray, array_flip($keysToExtract));
             $mailContent = (object) ['stuName' => $rs->stuName, 'stuEmail'=>$rs->stuEmail,'refNo' => $rs->refNo,'courseName'=>$rs->courseName,'courseStartDate'=>$rs->courseStartDate,'courseEndDate'=>$rs->courseEndDate];
            Mail::to($rs->stuEmail)->send(new TestMail($mailContent));
            // return "Email sent successfully!";
            // die("SFasdf");
            // var_dump($resultArray); // Check the extracted array
            // $this->sendTestEmail($resultArray);
            // die("SFasdf");

        return redirect()->route('admin.certificates.index');
    }


    public function store2(StoreCertificateRequest $request)
    {
        $certificate = Certificate::create($request->all());
      $images = $request->input('thumbnail');
      foreach($images as $image){
       	File::copy(storage_path('tmp/uploads/'. $image), storage_path('uploads/'. $image));
      }
        foreach ($request->input('thumbnail', []) as $file) {
            $certificate->addMedia(storage_path('tmp/uploads/' . basename($file)))->toMediaCollection('thumbnail');
        }

        if ($media = $request->input('ck-media', false)) {
            Media::whereIn('id', $media)->update(['model_id' => $certificate->id]);
        }

        return redirect()->route('admin.certificates.index');
    }

    public function edit(Certificate $certificate)
    {
      //print_r($certificate);die();
        abort_if(Gate::denies('course_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');
	$certificate = Certificate::where('id', $certificate->id)->with(['media'])->get();
      
        $teachers = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $students = User::pluck('name', 'id');
      $studentList = RoleUser ::withTrashed()->select('user_id')->where('role_id', 3)->get();
      $studentList = $studentList->toArray();

      $ids = array_column($studentList, 'user_id');
      $studentAll = User::whereIn('id', $ids)->get();
        //$course->load('teacher', 'students');

        return view('admin.certificates.edit', compact('certificate', 'students', 'teachers', 'studentAll'));
    }

    public function update(UpdateCertificateRequest $request, Certificate $course)
    {
        $course->update($request->all());
        $images = $request->input('thumbnail');
      foreach($images as $image){
       	File::copy(storage_path('tmp/uploads/'. $image), storage_path('uploads/'. $image));
      }
        if (count($course->thumbnail) > 0) {
            foreach ($course->thumbnail as $media) {
                if (! in_array($media->file_name, $request->input('thumbnail', []))) {
                    $media->delete();
                }
            }
        }
        $media = $course->thumbnail->pluck('file_name')->toArray();
        foreach ($request->input('thumbnail', []) as $file) {
            if (count($media) === 0 || ! in_array($file, $media)) {
                $course->addMedia(storage_path('tmp/uploads/' . basename($file)))->toMediaCollection('thumbnail');
            }
        }

        return redirect()->route('admin.courses.index');
    }

    public function show(Course $course)
    {
        abort_if(Gate::denies('course_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $course->load('teacher', 'students');

        return view('admin.courses.show', compact('course'));
    }

    public function destroy(Course $course)
    {
        abort_if(Gate::denies('course_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $course->delete();

        return back();
    }

    public function massDestroy(MassDestroyCourseRequest $request)
    {
        $courses = Course::find(request('ids'));

        foreach ($courses as $course) {
            $course->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }

    public function storeCKEditorImages(Request $request)
    {
        abort_if(Gate::denies('course_create') && Gate::denies('course_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $model         = new Course();
        $model->id     = $request->input('crud_id', 0);
        $model->exists = true;
        $media         = $model->addMediaFromRequest('upload')->toMediaCollection('ck-media');

        return response()->json(['id' => $media->id, 'url' => $media->getUrl()], Response::HTTP_CREATED);
    }

    public function stuStore(Request $request)
    {

        $requestData = $request->input();
        if(isset($requestData['dob'])) {
            // Change the format of dob if it exists
            $requestData['dob'] = date("Y-m-d", strtotime($requestData['dob']));
        }

        // Check if email already exists in the database
        $existingEmail = DB::table('users')->where('email', $requestData['email'])->exists();

        // If email already exists, return a response with an error message
        if ($existingEmail) {
            return response()->json(['message' => 'Email already exists','is_error'=>1], 200);
        }
        $requestData['password'] = md5($requestData['password']);       

        $modifiedData = [
            'name' => $requestData['firstName'],
            'last_name' => $requestData['lastName'],
            'email' => $requestData['email'],
            'dob' => $requestData['dob'],
            'gender' => $requestData['gender'],
            'mobile_no' => $requestData['mobileNo'],
            'address_line_1' => $requestData['addressLine1'],
            'address_line_2' => $requestData['addressLine2'],
            'password' => $requestData['password']
        ];
       $lastStuID = DB::table('users')->insertGetId($modifiedData);
        if ($lastStuID) {
            DB::table('role_user')->insert(['user_id' => $lastStuID, 'role_id' => 3]);
        }
        return response()->json(['message' => 'Student added successfully','is_error'=>0], 200);
    }

    public function getEmailCertificate(Request $request)
    {
        $template = DB::table('email_template')->where('id', 1)->first();
        if ($template) {
            return response()->json(['rs' => $template],200);
        } else {
            return response()->json(['error' => 'Template not found'], 404);
        }
    }

    public function updateEmailCertificate(Request $request)
    {
        // Assuming 'emailSubject' and 'emailContent' are the keys in the request
        $emailSubject = $request->input('emailSubject');
        $emailContent = $request->input('emailContent');

        // Assuming you want to update based on the ID passed in the request
        $id = 1;//$request->input('id');

        $updated = DB::table('email_template')->where('id', $id)->update([
            'subject' => $emailSubject,  
            'email_content' => $emailContent 
        ]);

        if ($updated) {
            return response()->json(['message' => 'Successfully updated'], 200);
        } else {
            return response()->json(['error' => 'Record not found'], 404);
        }
    }
    
    public function createmanually()
    {
        die('hiii');
      abort_if(Gate::denies('course_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
      $studentList = RoleUser ::withTrashed()->select('user_id')->where('role_id', 3)->get();
      $studentList = $studentList->toArray();
      $ids = array_column($studentList, 'user_id');
      $studentAll = User::whereIn('id', $ids)->get();

        $teachers = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $students = User::pluck('name', 'id');

        return view('admin.certificates.create', compact('students', 'teachers', 'studentAll'));
    }
}
